let popupDomIndex = 1
class CustomPopup {
    constructor(view, wkid, coord, appendDom, dom,offSet=[0,0]) {
        this.view = view;
        this.wkid = wkid;
        this.appendDom = appendDom;
        this.dom = dom;
        this.coord = coord;
        this.offSet =  offSet //[x,y]
        // this.domIndex = popupDomIndex //多弹窗时候   用于操作对应的弹窗
    }

    init() {
        let _this = this
        _this.view.when(function () {
            let appendDom = typeof (_this.appendDom) === 'string' ? document.getElementById(_this.appendDom) : _this.appendDom
            let fixedDom = document.createElement("div")
            fixedDom.id = "cus_popup_id" + popupDomIndex++
            fixedDom.className = "cus_popup_cls"
            // fixedDom.setAttribute("style","position:absolute;z-index:999")
            let isDom = typeof (_this.dom) === 'string' ? true : false
            let dom;
            if (isDom) {
                dom = document.createElement('div')
                dom.id = 'popupId' + _this.dom
                dom.className = 'popup' + _this.dom
                dom.setAttribute("style", "width:200px;height:200px;background:red;")
            } else {
                dom = _this.dom
            }
            let mapPoint = {
                x: parseFloat(_this.coord[0]),
                y: parseFloat(_this.coord[1]),
                spatialReference: {
                    wkid: "4326",
                },
            };
            fixedDom.appendChild(dom)
            appendDom.appendChild(fixedDom)
            let offSetLen = [dom.offsetWidth,dom.offsetHeight]
            let screenPoint = _this.view.toScreen(mapPoint);
            _this.locationPopup(fixedDom, screenPoint,offSetLen)  //固定位置
            _this.view.watch("extent", function () {
                _this.upLocation(fixedDom, _this.coord,offSetLen);
            });
            _this.view.watch("rotation", function () {
                _this.upLocation(fixedDom, _this.coord,offSetLen);
            });
        })
    }
    show() {
        //先隐藏其他的弹窗
        //再显示现有的弹窗
    }

    close() {
        //关闭弹窗
        let popupParent = document.getElementById("cus_popup_id")
        if(popupParent){
            popupParent.removeChild(popupParent.childNodes[0])
        }
    }

    locationPopup(dom, screenPoint,offSetLen) {
        let theDom = dom;
        let screen_x = screenPoint.x - offSetLen[0]/2 - this.offSet[0]
        let screen_y = screenPoint.y - offSetLen[1] - this.offSet[1]
        console.log(screen_x)
        theDom.setAttribute(
            "style",
            `position:absolute;z-index:999;transform:translate3d(${screen_x}px,${screen_y}px,0)`
        );
    }

    upLocation(dom, point,offSetLen) {
        // let theDom = dom;
        let mapPoint = {
            x: parseFloat(point[0]),
            y: parseFloat(point[1]),
            spatialReference: {
                wkid: 4326
            }

        };
        let screenPoint = this.view.toScreen(mapPoint);
        let screen_x = screenPoint.x - offSetLen[0]/2 - this.offSet[0]
        let screen_y = screenPoint.y - offSetLen[1] - this.offSet[1]
        dom.setAttribute(
            "style",
            `position:absolute;z-index:999;transform:translate3d(${screen_x}px,${screen_y}px,0)`
        );
    }

}
export { CustomPopup }

