/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class H2URLParser
extends AbstractURLParser {
    private static final String LOCALHOST = "localhost";
    private static final int DEFAULT_PORT = 8084;
    private static final String FILE_MODE_FLAG = "file";
    private static final String MEMORY_MODE_FLAG = "mem";
    private static final String H2_DB_TYPE = "H2";

    public H2URLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        int hostLabelStartIndex = this.url.indexOf("//");
        int hostLabelEndIndex = this.url.indexOf("/", hostLabelStartIndex + 2);
        return new URLLocation(hostLabelStartIndex + 2, hostLabelEndIndex);
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseStartTag = this.url.lastIndexOf("/");
        int databaseEndTag = this.url.indexOf(";");
        if (databaseEndTag == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        int[] databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexFromURLForH2FileMode();
        if (databaseNameRangeIndex != null) {
            return new ConnectionInfo(ComponentsDefine.H2_JDBC_DRIVER, H2_DB_TYPE, LOCALHOST, -1, this.fetchDatabaseNameFromURL(databaseNameRangeIndex));
        }
        databaseNameRangeIndex = this.fetchDatabaseNameRangeIndexFromURLForH2MemMode();
        if (databaseNameRangeIndex != null) {
            return new ConnectionInfo(ComponentsDefine.H2_JDBC_DRIVER, H2_DB_TYPE, LOCALHOST, -1, this.fetchDatabaseNameFromURL(databaseNameRangeIndex));
        }
        String[] hostAndPort = this.fetchDatabaseHostsFromURL().split(":");
        if (hostAndPort.length == 1) {
            return new ConnectionInfo(ComponentsDefine.H2_JDBC_DRIVER, H2_DB_TYPE, hostAndPort[0], 8084, this.fetchDatabaseNameFromURL());
        }
        return new ConnectionInfo(ComponentsDefine.H2_JDBC_DRIVER, H2_DB_TYPE, hostAndPort[0], Integer.valueOf(hostAndPort[1]), this.fetchDatabaseNameFromURL());
    }

    private int[] fetchDatabaseNameRangeIndexFromURLForH2FileMode() {
        int fileLabelIndex = this.url.indexOf(FILE_MODE_FLAG);
        int parameterLabelIndex = this.url.indexOf(";", fileLabelIndex);
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = this.url.length();
        }
        if (fileLabelIndex != -1) {
            return new int[]{fileLabelIndex + FILE_MODE_FLAG.length() + 1, parameterLabelIndex};
        }
        return null;
    }

    private int[] fetchDatabaseNameRangeIndexFromURLForH2MemMode() {
        int fileLabelIndex = this.url.indexOf(MEMORY_MODE_FLAG);
        int parameterLabelIndex = this.url.indexOf(";", fileLabelIndex);
        if (parameterLabelIndex == -1) {
            parameterLabelIndex = this.url.length();
        }
        if (fileLabelIndex != -1) {
            return new int[]{fileLabelIndex + MEMORY_MODE_FLAG.length() + 1, parameterLabelIndex};
        }
        return null;
    }
}

