/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.reactive;

import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.reactive.ReactiveWebServerFactoryConfiguration;
import com.tongweb.springboot.autoconfigure.web.reactive.ReactiveWebServerFactoryCustomizer;
import com.tongweb.springboot.autoconfigure.web.reactive.TongWebReactiveWebServerFactoryCustomizer;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizerBeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.util.UriComponentsBuilder;

@AutoConfigureOrder(value=-2147483648)
@Configuration
@ConditionalOnClass(value={ReactiveHttpInputMessage.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={ServerProperties.class})
@Import(value={BeanPostProcessorsRegistrar.class, ReactiveWebServerFactoryConfiguration.EmbeddedTongWeb.class})
public class ReactiveWebServerFactoryAutoConfiguration {
    @Bean
    public ReactiveWebServerFactoryCustomizer reactiveTongWebServerFactoryCustomizer(ServerProperties serverProperties) {
        return new ReactiveWebServerFactoryCustomizer(serverProperties);
    }

    @Bean
    @ConditionalOnClass(name={"com.tongweb.container.startup.ServletContainer"})
    public TongWebReactiveWebServerFactoryCustomizer tongWebReactiveWebServerFactoryCustomizer(ServerProperties serverProperties) {
        return new TongWebReactiveWebServerFactoryCustomizer(serverProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"server.forward-headers-strategy"}, havingValue="framework")
    public ForwardedHeaderTransformer forwardedHeaderTransformerTongWeb() {
        return new ForwardedHeaderTransformer();
    }

    public static class ForwardedHeaderTransformer
    implements Function<ServerHttpRequest, ServerHttpRequest> {
        static final Set<String> FORWARDED_HEADER_NAMES = Collections.newSetFromMap(new LinkedCaseInsensitiveMap(8, Locale.ENGLISH));
        private boolean removeOnly;

        @Nullable
        private static String getForwardedPrefix(ServerHttpRequest request) {
            HttpHeaders headers = request.getHeaders();
            String prefix = headers.getFirst("X-Forwarded-Prefix");
            if (prefix != null) {
                int endIndex;
                for (endIndex = prefix.length(); endIndex > 1 && prefix.charAt(endIndex - 1) == '/'; --endIndex) {
                }
                prefix = endIndex != prefix.length() ? prefix.substring(0, endIndex) : prefix;
            }
            return prefix;
        }

        public boolean isRemoveOnly() {
            return this.removeOnly;
        }

        public void setRemoveOnly(boolean removeOnly) {
            this.removeOnly = removeOnly;
        }

        @Override
        public ServerHttpRequest apply(ServerHttpRequest request) {
            if (this.hasForwardedHeaders(request)) {
                ServerHttpRequest.Builder builder = request.mutate();
                if (!this.removeOnly) {
                    URI uri = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).build(true).toUri();
                    builder.uri(uri);
                    String prefix = ForwardedHeaderTransformer.getForwardedPrefix(request);
                    if (prefix != null) {
                        builder.path(prefix + uri.getRawPath());
                        builder.contextPath(prefix);
                    }
                }
                this.removeForwardedHeaders(builder);
                request = builder.build();
            }
            return request;
        }

        protected boolean hasForwardedHeaders(ServerHttpRequest request) {
            String headerName;
            HttpHeaders headers = request.getHeaders();
            Iterator<String> iterator = FORWARDED_HEADER_NAMES.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!headers.containsKey((Object)(headerName = iterator.next())));
            return true;
        }

        private void removeForwardedHeaders(ServerHttpRequest.Builder builder) {
            builder.headers(map -> FORWARDED_HEADER_NAMES.forEach(arg_0 -> ((HttpHeaders)map).remove(arg_0)));
        }

        static {
            FORWARDED_HEADER_NAMES.add("Forwarded");
            FORWARDED_HEADER_NAMES.add("X-Forwarded-Host");
            FORWARDED_HEADER_NAMES.add("X-Forwarded-Port");
            FORWARDED_HEADER_NAMES.add("X-Forwarded-Proto");
            FORWARDED_HEADER_NAMES.add("X-Forwarded-Prefix");
            FORWARDED_HEADER_NAMES.add("X-Forwarded-Ssl");
        }
    }

    public static class BeanPostProcessorsRegistrar
    implements ImportBeanDefinitionRegistrar,
    BeanFactoryAware {
        private ConfigurableListableBeanFactory beanFactory;

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            if (beanFactory instanceof ConfigurableListableBeanFactory) {
                this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
            }
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.beanFactory == null) {
                return;
            }
            this.registerSyntheticBeanIfMissing(registry, "webServerFactoryCustomizerBeanPostProcessor", WebServerFactoryCustomizerBeanPostProcessor.class);
        }

        private void registerSyntheticBeanIfMissing(BeanDefinitionRegistry registry, String name, Class<?> beanClass) {
            if (ObjectUtils.isEmpty((Object[])this.beanFactory.getBeanNamesForType(beanClass, true, false))) {
                RootBeanDefinition beanDefinition = new RootBeanDefinition(beanClass);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
            }
        }
    }
}

