/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.lc.service.instance.limit.in;

import java.io.Serializable;
import java.util.logging.Logger;

public class InstanceLimitBean
implements Serializable {
    private static final Logger log = Logger.getLogger(InstanceLimitBean.class.getName());
    private String edition;
    private Integer limitNumber;
    private Double limitMark;
    private String level;
    private Integer limitMarkNumber;
    private String message;
    private Integer currentNumber = 0;

    public InstanceLimitBean() {
    }

    public InstanceLimitBean(String edition) {
        this.edition = edition;
    }

    public InstanceLimitBean(String edition, Integer limitNumber, Double limitMark, String level, Integer limitMarkNumber, String message) {
        this.edition = edition;
        this.limitNumber = limitNumber;
        this.limitMark = limitMark;
        this.level = level;
        this.limitMarkNumber = limitMarkNumber;
        this.message = message;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public Integer getLimitNumber() {
        return this.limitNumber;
    }

    public void setLimitNumber(Integer limitNumber) {
        this.limitNumber = limitNumber;
    }

    public Double getLimitMark() {
        return this.limitMark;
    }

    public void setLimitMark(Double limitMark) {
        this.limitMark = limitMark;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public Integer getLimitMarkNumber() {
        return this.limitMarkNumber;
    }

    public void setLimitMarkNumber(Integer limitMarkNumber) {
        this.limitMarkNumber = limitMarkNumber;
    }

    public Integer getCurrentNumber() {
        return this.currentNumber;
    }

    public void setCurrentNumber(Integer currentNumber) {
        this.currentNumber = currentNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean calculateDistance(int currentNumber) {
        this.setCurrentNumber(currentNumber);
        return currentNumber - this.limitMarkNumber >= 0;
    }

    public String generateMessage() {
        if (this.getCurrentNumber() > this.limitMarkNumber) {
            return "TongWeb [" + this.edition + "] current number of instance : " + this.currentNumber + " more than maximum limit " + this.message + " number[" + this.limitMarkNumber + "](" + this.limitNumber + "*" + this.limitMark + ")";
        }
        if (this.getCurrentNumber().equals(this.limitMarkNumber)) {
            return "TongWeb [" + this.edition + "] current number of instance : " + this.currentNumber + " equal to maximum limit " + this.message + " number[" + this.limitMarkNumber + "](" + this.limitNumber + "*" + this.limitMark + ")";
        }
        return "";
    }

    public void printLimitMessage() {
        String tmp = this.generateMessage();
        if (tmp != null && tmp.length() != 0) {
            switch (this.getLevel()) {
                case "null": {
                    break;
                }
                case "fatal": {
                    log.severe(tmp);
                    break;
                }
                case "error": {
                    log.severe(tmp);
                    break;
                }
                case "warn": {
                    log.warning(tmp);
                    break;
                }
            }
        }
    }

    public String toString() {
        return "InstanceLimitBean{edition='" + this.edition + '\'' + ", limitNumber=" + this.limitNumber + ", limitMark=" + this.limitMark + ", level='" + this.level + '\'' + ", limitMarkNumber=" + this.limitMarkNumber + ", currentNumber=" + this.currentNumber + '}';
    }
}

