/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.pojo;

import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.healthcheck.HealthCheckStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.atomic.AtomicInteger;

public class HealthCheckInstancePublishInfo
extends InstancePublishInfo {
    private static final long serialVersionUID = 5424801693490263492L;
    private long lastHeartBeatTime = System.currentTimeMillis();
    private HealthCheckStatus healthCheckStatus;

    public HealthCheckInstancePublishInfo() {
    }

    public HealthCheckInstancePublishInfo(String ip, int port) {
        super(ip, port);
    }

    public long getLastHeartBeatTime() {
        return this.lastHeartBeatTime;
    }

    public void setLastHeartBeatTime(long lastHeartBeatTime) {
        this.lastHeartBeatTime = lastHeartBeatTime;
    }

    public void initHealthCheck() {
        this.healthCheckStatus = new HealthCheckStatus();
    }

    public boolean tryStartCheck() {
        return this.healthCheckStatus.isBeingChecked.compareAndSet(false, true);
    }

    public void finishCheck() {
        this.healthCheckStatus.isBeingChecked.set(false);
    }

    public void resetOkCount() {
        this.healthCheckStatus.checkOkCount.set(0);
    }

    public void resetFailCount() {
        this.healthCheckStatus.checkFailCount.set(0);
    }

    public void setCheckRt(long checkRt) {
        this.healthCheckStatus.checkRt = checkRt;
    }

    @JsonIgnore
    public AtomicInteger getOkCount() {
        return this.healthCheckStatus.checkOkCount;
    }

    @JsonIgnore
    public AtomicInteger getFailCount() {
        return this.healthCheckStatus.checkFailCount;
    }
}

