/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v6.interceptor;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.common.RestClientEnhanceInfo;
import org.apache.skywalking.apm.plugin.elasticsearch.v6.ElasticsearchPluginConfig;
import org.elasticsearch.action.index.IndexRequest;

public class RestHighLevelClientIndexMethodsInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        IndexRequest indexRequest = (IndexRequest)allArguments[0];
        RestClientEnhanceInfo restClientEnhanceInfo = (RestClientEnhanceInfo)objInst.getSkyWalkingDynamicField();
        AbstractSpan span = ContextManager.createExitSpan((String)"Elasticsearch/IndexRequest", (String)restClientEnhanceInfo.getPeers());
        span.setComponent((Component)ComponentsDefine.REST_HIGH_LEVEL_CLIENT);
        Tags.DB_TYPE.set(span, "Elasticsearch");
        Tags.DB_INSTANCE.set(span, indexRequest.index());
        if (ElasticsearchPluginConfig.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, indexRequest.toString());
        }
        SpanLayer.asDB((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

