/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.CounterMode;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class CapacityManagementAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityManagementAspect.class);
    private static final String SYNC_UPDATE_CONFIG_ALL = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,content,appName,srcUser,tenant,tag,..)";
    private static final String DELETE_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)";
    private final CapacityService capacityService;
    private final ConfigInfoPersistService configInfoPersistService;

    public CapacityManagementAspect(ConfigInfoPersistService configInfoPersistService, CapacityService capacityService) {
        this.configInfoPersistService = configInfoPersistService;
        this.capacityService = capacityService;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,content,appName,srcUser,tenant,tag,..)")
    public Object aroundSyncUpdateConfigAll(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String content, String appName, String srcUser, String tenant, String tag) throws Throwable {
        if (!PropertyUtil.isManageCapacity()) {
            return pjp.proceed();
        }
        LOGGER.info("[capacityManagement] aroundSyncUpdateConfigAll");
        String betaIps = request.getHeader("betaIps");
        if (StringUtils.isBlank((CharSequence)betaIps) && StringUtils.isBlank((CharSequence)tag)) {
            if (this.configInfoPersistService.findConfigInfo(dataId, group, tenant) == null) {
                return this.do4Insert(pjp, request, response, group, tenant, content);
            }
            return this.do4Update(pjp, request, response, dataId, group, tenant, content);
        }
        return pjp.proceed();
    }

    private Object do4Update(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String content) throws Throwable {
        if (!PropertyUtil.isCapacityLimitCheck()) {
            return pjp.proceed();
        }
        try {
            boolean hasTenant = this.hasTenant(tenant);
            Capacity capacity = this.getCapacity(group, tenant, hasTenant);
            if (this.isSizeLimited(group, tenant, this.getCurrentSize(content), hasTenant, false, capacity)) {
                return this.response4Limit(request, response, LimitType.OVER_MAX_SIZE);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] do4Update ", (Throwable)e);
        }
        return pjp.proceed();
    }

    private Object do4Insert(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String group, String tenant, String content) throws Throwable {
        LOGGER.info("[capacityManagement] do4Insert");
        CounterMode counterMode = CounterMode.INCREMENT;
        boolean hasTenant = this.hasTenant(tenant);
        if (PropertyUtil.isCapacityLimitCheck()) {
            LimitType limitType = this.getLimitType(counterMode, group, tenant, content, hasTenant);
            if (limitType != null) {
                return this.response4Limit(request, response, limitType);
            }
        } else {
            this.insertOrUpdateUsage(group, tenant, counterMode, hasTenant);
        }
        return this.getResult(pjp, response, group, tenant, counterMode, hasTenant);
    }

    private Object response4Limit(HttpServletRequest request, HttpServletResponse response, LimitType limitType) {
        response.setStatus(limitType.status);
        return String.valueOf(limitType.status);
    }

    private boolean hasTenant(String tenant) {
        return StringUtils.isNotBlank((String)tenant);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)")
    public Object aroundDeleteConfig(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        if (!PropertyUtil.isManageCapacity()) {
            return pjp.proceed();
        }
        LOGGER.info("[capacityManagement] aroundDeleteConfig");
        ConfigInfoWrapper configInfo = this.configInfoPersistService.findConfigInfo(dataId, group, tenant);
        if (configInfo == null) {
            return pjp.proceed();
        }
        return this.do4Delete(pjp, response, group, tenant, configInfo);
    }

    private Object do4Delete(ProceedingJoinPoint pjp, HttpServletResponse response, String group, String tenant, ConfigInfo configInfo) throws Throwable {
        boolean hasTenant = this.hasTenant(tenant);
        if (configInfo == null) {
            this.correctUsage(group, tenant, hasTenant);
            return pjp.proceed();
        }
        CounterMode counterMode = CounterMode.DECREMENT;
        this.insertOrUpdateUsage(group, tenant, counterMode, hasTenant);
        return this.getResult(pjp, response, group, tenant, counterMode, hasTenant);
    }

    private void correctUsage(String group, String tenant, boolean hasTenant) {
        try {
            if (hasTenant) {
                LOGGER.info("[capacityManagement] correct usage, tenant: {}", (Object)tenant);
                this.capacityService.correctTenantUsage(tenant);
            } else {
                LOGGER.info("[capacityManagement] correct usage, group: {}", (Object)group);
                this.capacityService.correctGroupUsage(group);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] correctUsage ", (Throwable)e);
        }
    }

    private Object getResult(ProceedingJoinPoint pjp, HttpServletResponse response, String group, String tenant, CounterMode counterMode, boolean hasTenant) throws Throwable {
        try {
            Object result = pjp.proceed();
            this.doResult(counterMode, response, group, tenant, result, hasTenant);
            return result;
        }
        catch (Throwable throwable) {
            LOGGER.warn("[capacityManagement] inner operation throw exception, rollback, group: {}, tenant: {}", new Object[]{group, tenant, throwable});
            this.rollback(counterMode, group, tenant, hasTenant);
            throw throwable;
        }
    }

    private void insertOrUpdateUsage(String group, String tenant, CounterMode counterMode, boolean hasTenant) {
        try {
            this.capacityService.insertAndUpdateClusterUsage(counterMode, true);
            if (hasTenant) {
                this.capacityService.insertAndUpdateTenantUsage(counterMode, tenant, true);
            } else {
                this.capacityService.insertAndUpdateGroupUsage(counterMode, group, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] insertOrUpdateUsage ", (Throwable)e);
        }
    }

    private LimitType getLimitType(CounterMode counterMode, String group, String tenant, String content, boolean hasTenant) {
        try {
            boolean clusterLimited;
            boolean bl = clusterLimited = !this.capacityService.insertAndUpdateClusterUsage(counterMode, false);
            if (clusterLimited) {
                LOGGER.warn("[capacityManagement] cluster capacity reaches quota.");
                return LimitType.OVER_CLUSTER_QUOTA;
            }
            if (content == null) {
                return null;
            }
            int currentSize = this.getCurrentSize(content);
            LimitType limitType = this.getGroupOrTenantLimitType(counterMode, group, tenant, currentSize, hasTenant);
            if (limitType != null) {
                this.rollbackClusterUsage(counterMode);
                return limitType;
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] isLimited ", (Throwable)e);
        }
        return null;
    }

    private int getCurrentSize(String content) {
        try {
            return content.getBytes(StandardCharsets.UTF_8).length;
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] getCurrentSize ", (Throwable)e);
            return 0;
        }
    }

    private LimitType getGroupOrTenantLimitType(CounterMode counterMode, String group, String tenant, int currentSize, boolean hasTenant) {
        boolean updateSuccess;
        if (group == null) {
            return null;
        }
        Capacity capacity = this.getCapacity(group, tenant, hasTenant);
        if (this.isSizeLimited(group, tenant, currentSize, hasTenant, false, capacity)) {
            return LimitType.OVER_MAX_SIZE;
        }
        if (capacity == null) {
            this.insertCapacity(group, tenant, hasTenant);
        }
        if (updateSuccess = this.isUpdateSuccess(counterMode, group, tenant, hasTenant)) {
            return null;
        }
        if (hasTenant) {
            return LimitType.OVER_TENANT_QUOTA;
        }
        return LimitType.OVER_GROUP_QUOTA;
    }

    private boolean isUpdateSuccess(CounterMode counterMode, String group, String tenant, boolean hasTenant) {
        boolean updateSuccess;
        if (hasTenant) {
            updateSuccess = this.capacityService.updateTenantUsage(counterMode, tenant);
            if (!updateSuccess) {
                LOGGER.warn("[capacityManagement] tenant capacity reaches quota, tenant: {}", (Object)tenant);
            }
        } else {
            updateSuccess = this.capacityService.updateGroupUsage(counterMode, group);
            if (!updateSuccess) {
                LOGGER.warn("[capacityManagement] group capacity reaches quota, group: {}", (Object)group);
            }
        }
        return updateSuccess;
    }

    private void insertCapacity(String group, String tenant, boolean hasTenant) {
        if (hasTenant) {
            this.capacityService.initTenantCapacity(tenant);
        } else {
            this.capacityService.initGroupCapacity(group);
        }
    }

    private Capacity getCapacity(String group, String tenant, boolean hasTenant) {
        Capacity capacity = hasTenant ? this.capacityService.getTenantCapacity(tenant) : this.capacityService.getGroupCapacity(group);
        return capacity;
    }

    private boolean isSizeLimited(String group, String tenant, int currentSize, boolean hasTenant, boolean isAggr, Capacity capacity) {
        int defaultMaxSize = this.getDefaultMaxSize(isAggr);
        if (capacity != null) {
            Integer maxSize = this.getMaxSize(isAggr, capacity);
            if (maxSize == 0) {
                return this.isOverSize(group, tenant, currentSize, defaultMaxSize, hasTenant);
            }
            return this.isOverSize(group, tenant, currentSize, maxSize, hasTenant);
        }
        return this.isOverSize(group, tenant, currentSize, defaultMaxSize, hasTenant);
    }

    private Integer getMaxSize(boolean isAggr, Capacity capacity) {
        if (isAggr) {
            return capacity.getMaxAggrSize();
        }
        return capacity.getMaxSize();
    }

    private int getDefaultMaxSize(boolean isAggr) {
        if (isAggr) {
            return PropertyUtil.getDefaultMaxAggrSize();
        }
        return PropertyUtil.getDefaultMaxSize();
    }

    private boolean isOverSize(String group, String tenant, int currentSize, int maxSize, boolean hasTenant) {
        if (currentSize > maxSize) {
            if (hasTenant) {
                LOGGER.warn("[capacityManagement] tenant content is over maxSize, tenant: {}, maxSize: {}, currentSize: {}", new Object[]{tenant, maxSize, currentSize});
            } else {
                LOGGER.warn("[capacityManagement] group content is over maxSize, group: {}, maxSize: {}, currentSize: {}", new Object[]{group, maxSize, currentSize});
            }
            return true;
        }
        return false;
    }

    private void doResult(CounterMode counterMode, HttpServletResponse response, String group, String tenant, Object result, boolean hasTenant) {
        try {
            if (!this.isSuccess(response, result)) {
                LOGGER.warn("[capacityManagement] inner operation is fail, rollback, counterMode: {}, group: {}, tenant: {}", new Object[]{counterMode, group, tenant});
                this.rollback(counterMode, group, tenant, hasTenant);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] doResult ", (Throwable)e);
        }
    }

    private boolean isSuccess(HttpServletResponse response, Object result) {
        int status = response.getStatus();
        if (status == 200) {
            return true;
        }
        LOGGER.warn("[capacityManagement] response status is not 200, status: {}, result: {}", (Object)status, result);
        return false;
    }

    private void rollback(CounterMode counterMode, String group, String tenant, boolean hasTenant) {
        try {
            this.rollbackClusterUsage(counterMode);
            if (hasTenant) {
                this.capacityService.updateTenantUsage(counterMode.reverse(), tenant);
            } else {
                this.capacityService.updateGroupUsage(counterMode.reverse(), group);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] rollback ", (Throwable)e);
        }
    }

    private void rollbackClusterUsage(CounterMode counterMode) {
        try {
            if (!this.capacityService.updateClusterUsage(counterMode.reverse())) {
                LOGGER.error("[capacityManagement] cluster usage rollback fail counterMode: {}", (Object)counterMode);
            }
        }
        catch (Exception e) {
            LOGGER.error("[capacityManagement] rollback ", (Throwable)e);
        }
    }

    public static enum LimitType {
        OVER_CLUSTER_QUOTA("\u8d85\u8fc7\u96c6\u7fa4\u914d\u7f6e\u4e2a\u6570\u4e0a\u9650", 429),
        OVER_GROUP_QUOTA("\u8d85\u8fc7\u8be5Group\u914d\u7f6e\u4e2a\u6570\u4e0a\u9650", 429),
        OVER_TENANT_QUOTA("\u8d85\u8fc7\u8be5\u79df\u6237\u914d\u7f6e\u4e2a\u6570\u4e0a\u9650", 429),
        OVER_MAX_SIZE("\u8d85\u8fc7\u914d\u7f6e\u7684\u5185\u5bb9\u5927\u5c0f\u4e0a\u9650", 429);

        public final String description;
        public final int status;

        private LimitType(String description, int status) {
            this.description = description;
            this.status = status;
        }
    }
}

