/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.merge;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.merge.MergeDataTask;
import com.alibaba.nacos.config.server.service.merge.MergeTaskProcessor;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.utils.ContentUtils;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.persistence.configuration.DatasourceConfiguration;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MergeDatumService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeDatumService.class);
    final TaskManager mergeTasks;
    static final int INIT_THREAD_COUNT = 40;
    static final AtomicInteger FINISHED = new AtomicInteger();
    static int total = 0;
    private ConfigInfoPersistService configInfoPersistService;
    private ConfigInfoAggrPersistService configInfoAggrPersistService;

    @Autowired
    public MergeDatumService(ConfigInfoPersistService configInfoPersistService, ConfigInfoAggrPersistService configInfoAggrPersistService, ConfigInfoTagPersistService configInfoTagPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoAggrPersistService = configInfoAggrPersistService;
        this.mergeTasks = new TaskManager("com.alibaba.nacos.MergeDatum");
        this.mergeTasks.setDefaultTaskProcessor(new MergeTaskProcessor(configInfoPersistService, configInfoAggrPersistService, configInfoTagPersistService, this));
    }

    public List<List<ConfigInfoChanged>> splitList(List<ConfigInfoChanged> list, int count) {
        int i;
        ArrayList<List<ConfigInfoChanged>> result = new ArrayList<List<ConfigInfoChanged>>(count);
        for (i = 0; i < count; ++i) {
            result.add(new ArrayList());
        }
        for (i = 0; i < list.size(); ++i) {
            ConfigInfoChanged config = list.get(i);
            ((List)result.get(i % count)).add(config);
        }
        return result;
    }

    public void addMergeTask(String dataId, String groupId, String tenant, String clientIp) {
        if (!this.canExecute()) {
            return;
        }
        MergeDataTask task = new MergeDataTask(dataId, groupId, tenant, clientIp);
        this.mergeTasks.addTask((Object)task.getId(), task);
    }

    private boolean canExecute() {
        if (!DatasourceConfiguration.isEmbeddedStorage()) {
            return true;
        }
        if (EnvUtil.getStandaloneMode()) {
            return true;
        }
        ProtocolManager protocolManager = (ProtocolManager)ApplicationUtils.getBean(ProtocolManager.class);
        return protocolManager.getCpProtocol().isLeader("nacos_config");
    }

    void executeMergeConfigTask(List<ConfigInfoChanged> configInfoList, int pageSize) {
        for (ConfigInfoChanged configInfo : configInfoList) {
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String tenant = configInfo.getTenant();
            try {
                ArrayList<ConfigInfoAggr> datumList = new ArrayList<ConfigInfoAggr>();
                int rowCount = this.configInfoAggrPersistService.aggrConfigInfoCount(dataId, group, tenant);
                int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
                for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
                    Page<ConfigInfoAggr> page = this.configInfoAggrPersistService.findConfigInfoAggrByPage(dataId, group, tenant, pageNo, pageSize);
                    if (page == null) continue;
                    datumList.addAll(page.getPageItems());
                    LOGGER.info("[merge-query] {}, {}, size/total={}/{}", new Object[]{dataId, group, datumList.size(), rowCount});
                }
                if (datumList.size() > 0) {
                    String aggrConetentMD5;
                    ConfigInfo cf = MergeTaskProcessor.merge(dataId, group, tenant, datumList);
                    String aggrContent = cf.getContent();
                    String localContentMD5 = ConfigCacheService.getContentMd5(GroupKey.getKey(dataId, group));
                    if (!StringUtils.equals((String)localContentMD5, (String)(aggrConetentMD5 = MD5Utils.md5Hex((String)aggrContent, (String)"UTF-8")))) {
                        this.configInfoPersistService.insertOrUpdate(null, null, cf, null);
                        LOGGER.info("[merge-ok] {}, {}, size={}, length={}, md5={}, content={}", new Object[]{dataId, group, datumList.size(), cf.getContent().length(), cf.getMd5(), ContentUtils.truncateContent(cf.getContent())});
                    }
                } else {
                    this.configInfoPersistService.removeConfigInfo(dataId, group, tenant, InetUtils.getSelfIP(), null);
                    LOGGER.warn("[merge-delete] delete config info because no datum. dataId=" + dataId + ", groupId=" + group);
                }
            }
            catch (Throwable e) {
                LOGGER.info("[merge-error] " + dataId + ", " + group + ", " + e.toString(), e);
            }
            FINISHED.incrementAndGet();
            if (FINISHED.get() % 100 != 0) continue;
            LOGGER.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)total);
        }
        LOGGER.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)total);
    }

    public void executeConfigsMerge(List<ConfigInfoChanged> configInfoList) {
        new MergeAllDataWorker(configInfoList).start();
    }

    public class MergeAllDataWorker
    extends Thread {
        static final int PAGE_SIZE = 10000;
        private List<ConfigInfoChanged> configInfoList;

        public MergeAllDataWorker(List<ConfigInfoChanged> configInfoList) {
            super("MergeAllDataWorker");
            this.configInfoList = configInfoList;
        }

        @Override
        public void run() {
            MergeDatumService.this.executeMergeConfigTask(this.configInfoList, 10000);
        }
    }
}

