/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster.health;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.health.AbstractModuleHealthChecker;
import com.alibaba.nacos.core.cluster.health.ReadinessResult;
import java.util.LinkedList;
import java.util.List;

public class ModuleHealthCheckerHolder {
    private static final ModuleHealthCheckerHolder INSTANCE = new ModuleHealthCheckerHolder();
    private final List<AbstractModuleHealthChecker> moduleHealthCheckers = new LinkedList<AbstractModuleHealthChecker>();

    private ModuleHealthCheckerHolder() {
    }

    public static ModuleHealthCheckerHolder getInstance() {
        return INSTANCE;
    }

    public void registerChecker(AbstractModuleHealthChecker checker) {
        this.moduleHealthCheckers.add(checker);
    }

    public ReadinessResult checkReadiness() {
        LinkedList<String> readinessFailedModule = new LinkedList<String>();
        for (AbstractModuleHealthChecker each : this.moduleHealthCheckers) {
            boolean moduleReadiness = each.readiness();
            if (moduleReadiness) continue;
            readinessFailedModule.add(each.getModuleName());
        }
        if (readinessFailedModule.isEmpty()) {
            return new ReadinessResult(true, "OK");
        }
        String modules = StringUtils.join(readinessFailedModule, (String)" and ");
        return new ReadinessResult(false, String.format("%s not in readiness", modules));
    }
}

