/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.config;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.istio.IstioApp;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.filter.NacosPackageExcludeFilter;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IstioEnabledFilter
implements NacosPackageExcludeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IstioEnabledFilter.class);
    private static final String ISTIO_ENABLED_KEY = "nacos.extension.naming.istio.enabled";

    public String getResponsiblePackagePrefix() {
        return IstioApp.class.getPackage().getName();
    }

    public boolean isExcluded(String className, Set<String> annotationNames) {
        boolean istioDisabled;
        String functionMode = EnvUtil.getFunctionMode();
        if (this.isNamingDisabled(functionMode)) {
            LOGGER.warn("Istio module disabled because function mode is {}, and Istio depend naming module", (Object)functionMode);
            return true;
        }
        boolean bl = istioDisabled = (Boolean)EnvUtil.getProperty((String)ISTIO_ENABLED_KEY, Boolean.class, (Object)false) == false;
        if (istioDisabled) {
            LOGGER.warn("Istio module disabled because set {} as false", (Object)ISTIO_ENABLED_KEY);
        }
        return istioDisabled;
    }

    private boolean isNamingDisabled(String functionMode) {
        if (StringUtils.isEmpty((String)functionMode)) {
            return false;
        }
        return !"naming".equals(functionMode);
    }
}

