package org.dromara.zjk.domain.bo;

import org.dromara.zjk.domain.LearningSuggest;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 【请填写功能名称】业务对象 zjk_learning_suggest
 *
 * @author ygh
 * @date 2025-07-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = LearningSuggest.class, reverseConvertGenerate = false)
public class LearningSuggestBo extends BaseEntity {

    /**
     * 租户号
     */
    private String ID;

    /**
     * 推荐名称;zjk_learning_course主键
     */
    @NotBlank(message = "推荐名称;zjk_learning_course主键不能为空", groups = { AddGroup.class, EditGroup.class })
    private String suggestName;

    /**
     * 推荐内容
     */
    @NotBlank(message = "推荐内容不能为空", groups = { AddGroup.class, EditGroup.class })
    private String suggestContent;

    /**
     * 关联附件id
     */
    private Long fileId;
    private String expertName;

}
