package org.dromara.zjk.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 专家报表详情列表
 */
@Data
@ExcelIgnoreUnannotated
public class FpReportInVO implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    private Long moneyId;

    /**
     * 项目名称
     */
    @ExcelProperty(value = "项目名称")
    private String productName;
    /**
     * 项目阶段
     */
    @ExcelProperty(value = "项目阶段")
    private String reviewSn;
    /**
     * 专家姓名
     */
    @ExcelProperty(value = "专家姓名")
    private String expertName;

    /**
     * 结算单号
     */
    @ExcelProperty(value = "结算单号")
    private String settlementSn;

    @ExcelProperty(value = "结算金额")
    private BigDecimal settlementMoney;

    /**
     * 开票情况 （已开票/未开票）
     */
    @ExcelProperty(value = "开票情况")
    private String invStu;
    /**
     * 开票总金额
     */
    @ExcelProperty(value = "开票总金额")
    private BigDecimal invoiceMoney;

}
