package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkCreditRule;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 信用规则视图对象 zjk_credit_rule
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkCreditRule.class)
public class ZjkCreditRuleVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private Long ID;

    /**
     * 规则名称
     */
    @ExcelProperty(value = "规则名称")
    private String ruleName;

    /**
     * 到期时间
     */
    @ExcelProperty(value = "到期时间")
    private Date expireTime;

    /**
     * 是否永久
     */
    @ExcelProperty(value = "是否永久")
    private Long isForever;

    /**
     * 启用标识
     */
    @ExcelProperty(value = "启用标识")
    private Long status;

    /**
     * 创建人
     */
    @ExcelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新人
     */
    @ExcelProperty(value = "更新人")
    private Long updateBy;

    /**
     * 更新时间
     */
    @ExcelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 每次得分
     */
    @ExcelProperty(value = "每次得分")
    private Long eachScore;

    /**
     * 信用规则code
     */
    @ExcelProperty(value = "信用规则code")
    private Long ruleKey;

    /**
     * 信用获得事由
     */
    @ExcelProperty(value = "信用获得事由")
    private String pointReason;

    /**
     * 数据编号
     * */
    private Long dataNumber;


}
