package org.dromara.zjk.domain.vo;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.zjk.domain.ZjkCreditLv;
import org.dromara.zjk.domain.ZjkCreditUser;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.domain.ZjkExpert;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;



/**
 * 信用用户管理视图对象 zjk_credit_user
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkCreditUser.class)
public class ZjkCreditUserVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 租户号
     */
    @ExcelProperty(value = "租户号")
    private String ID;

    /**
     * 用户id
     */
    @ExcelProperty(value = "用户id")
    private Long userId;

    /**
     * 专家id
     */
    @ExcelProperty(value = "专家id")
    private Long expertId;

    /**
     * 奖励id
     */
    @ExcelProperty(value = "奖励id")
    private String rewardId;

    /**
     * 奖励内容
     */
    @ExcelProperty(value = "奖励内容")
    private String rewardTitle;

    /**
     * 总信用
     */
    @ExcelProperty(value = "总信用")
    private Long creditCount;

    /**
     * 创建人
     */
    @ExcelProperty(value = "创建人")
    private Long createBy;

    /**
     * 创建时间
     */
    @ExcelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新人
     */
    @ExcelProperty(value = "更新人")
    private Long updateBy;

    /**
     * 更新时间
     */
    @ExcelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 信用变动时间
     */
    @ExcelProperty(value = "信用变动时间")
    private Date changeTime;

    //专家信息
    private ZjkExpert zjkExpert;

    //等级Id
    private Long lvId;

    private ZjkCreditLvVo zjkCreditLvVo;




}
