package org.dromara.zjk.learning_world.domain.vo;


import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningTool;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 学习工具管理视图对象 zjk_learning_tool
 *
 * @author ygh
 * @date 2024-11-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningTool.class)
public class ZjkLearningToolVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 工具名称
     */
    @ExcelProperty(value = "工具名称")
    private String name;

    /**
     * 附件
     */
    @ExcelProperty(value = "附件")
    private String attachment;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 附件 url
     */
    private String url;

    /**
     * 附件名称
     */
    private String originalName;

    private Date takedownTime;
}
