package org.dromara.zjk.learning_world.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.common.tenant.helper.TenantHelper;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.mapper.ZjkExpertMapper;
import org.springframework.stereotype.Service;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningCommunityBo;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningCommunityVo;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommunity;
import org.dromara.zjk.learning_world.mapper.ZjkLearningCommunityMapper;
import org.dromara.zjk.learning_world.service.IZjkLearningCommunityService;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Collection;
import java.util.stream.Collectors;

/**
 * 社区管理Service业务层处理
 *
 * @author ygh
 * @date 2024-11-08
 */
@RequiredArgsConstructor
@Service
public class ZjkLearningCommunityServiceImpl implements IZjkLearningCommunityService {

    private final ZjkLearningCommunityMapper baseMapper;

    private final ZjkExpertMapper expertMapper;


    /**
     * 修改社区管理
     *
     * @param bo 社区管理
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkLearningCommunityBo bo) {
        ZjkLearningCommunity update = MapstructUtils.convert(bo, ZjkLearningCommunity.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    @Override
    public ZjkLearningCommunityVo getLearningCommunity() {

        LambdaQueryWrapper<ZjkLearningCommunity> lqw = Wrappers.lambdaQuery();
        lqw.eq(ZjkLearningCommunity::getTenantId, TenantHelper.getTenantId());
        lqw.last("limit 1" );

        ZjkLearningCommunityVo learningCommunityVo = baseMapper.selectVoOne(lqw);
        if(learningCommunityVo != null){
            Long createBy = learningCommunityVo.getCreateBy();
            List<ZjkExpertVo> zjkExpertVos = expertMapper.selectByUserIds(Arrays.asList(createBy));
            if(!CollectionUtil.isEmpty(zjkExpertVos)){
                if(!CollectionUtil.isEmpty(zjkExpertVos)){
                    Map<Long, ZjkExpertVo> getExpertMap = zjkExpertVos.stream().collect(Collectors.toMap(ZjkExpertVo::getUserId, v -> v));
                    ZjkExpertVo zjkExpertVo = getExpertMap.get(createBy);
                    learningCommunityVo.setUserName(zjkExpertVo.getUserName());
                    learningCommunityVo.setDeptName(zjkExpertVo.getDeptName());
                }
            }
            return learningCommunityVo;

        }
        ZjkLearningCommunity learningCommunity = new ZjkLearningCommunity();
        baseMapper.insert(learningCommunity);
        return BeanUtil.copyProperties(learningCommunity, ZjkLearningCommunityVo.class );
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkLearningCommunity entity){
        //TODO 做一些数据校验,如唯一约束
    }

}
