package org.dromara.zjk.mapper;

import org.dromara.zjk.domain.ZjkExpertChart;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.dromara.zjk.domain.dto.ProGetDto;
import org.dromara.zjk.domain.dto.SimpleExpertDto;

import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_expert_chart(专家画像)】的数据库操作Mapper
* @createDate 2024-11-13 10:20:57
* @Entity org.dromara.zjk.domain.ZjkExpertChart
*/
public interface ZjkExpertChartMapper extends BaseMapper<ZjkExpertChart> {

    List<ZjkExpertChart> getHandleData();

    void removeAll();

    List<SimpleExpertDto> getSameSchoolExperts(Long userId);

    List<SimpleExpertDto> getSameUnitExperts(Long userId);

    List<SimpleExpertDto> getSameProExperts(Long userId);

    String getExpertMajor(Long expertId);

    List<ProGetDto> getProSkills(Long expertId);

    String getCreditTitle(Long expertId);
}




