package org.dromara.zjk.utils;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Random;

public class NumberGenerator {

    public static String generateUniqueNumber(String prefix, int length) {
        // 获取当前日期
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String datePart = currentDate.format(formatter);

        // 获取当前纳秒时间并截取后五位
        long nanoTime = System.nanoTime();
        // 生成随机字符
        String randomPart = generateRandomString(length);

        // 拼接最终编号
        return prefix + "-" + datePart + "-" +nanoTime+randomPart;
    }

    private static String generateRandomString(int length) {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        Random random = new Random();

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }

    /**
     * 生成指定长度的数字随机字符串
     *
     * @param length 随机数的长度
     * @return 指定长度的数字随机字符串
     */
    public static String generateRandomNumber(int length) {
        String digits = "0123456789";
        StringBuilder sb = new StringBuilder();
        Random random = new Random();

        for (int i = 0; i < length; i++) {
            int index = random.nextInt(digits.length());
            sb.append(digits.charAt(index));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String uniqueNumber = generateUniqueNumber("NJBH", 5);
        System.out.println("生成的编号: " + uniqueNumber);
    }
}
