/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.exception;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.naming.misc.Loggers;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ResponseExceptionHandler {
    @ExceptionHandler(value={NacosException.class})
    public ResponseEntity<String> handleNacosException(NacosException e) {
        Loggers.SRV_LOG.error("got exception. {}", (Object)e.getErrMsg(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return ResponseEntity.status((int)e.getErrCode()).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={NacosRuntimeException.class})
    public ResponseEntity<String> handleNacosRuntimeException(NacosRuntimeException e) {
        Loggers.SRV_LOG.error("got exception. {}", (Object)e.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return ResponseEntity.status((int)e.getErrCode()).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<String> handleParameterError(IllegalArgumentException ex) {
        Loggers.SRV_LOG.error("got exception. {}", (Object)ex.getMessage(), (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)ex.getMessage());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<String> handleMissingParams(MissingServletRequestParameterException ex) {
        Loggers.SRV_LOG.error("got exception.", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)ex));
        String name = ex.getParameterName();
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)("Parameter '" + name + "' is missing"));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<String> handleException(Exception e) {
        Loggers.SRV_LOG.error("got exception.", (Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
    }
}

