package org.dromara.zjk.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 专家画像
 *
 * @TableName zjk_expert_chart
 */
@TableName(value = "zjk_expert_chart")
@Data
public class ZjkExpertChart implements Serializable {
    /**
     * 租户号
     */
    @TableId(value = "ID", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 专家id
     */
    @TableField(value = "expert_id")
    private Long expertId;

    /**
     * 用户id
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 业务领域得分
     */
    @TableField(value = "score_perform_work")
    private Object scorePerformWork;

    /**
     * 论文得分
     */
    @TableField(value = "score_paper")
    private Object scorePaper;

    /**
     * 专利得分
     */
    @TableField(value = "score_patent")
    private Object scorePatent;

    /**
     * 工作经历得分
     */
    @TableField(value = "score_work_year")
    private Object scoreWorkYear;

    /**
     * 荣誉奖项得分
     */
    @TableField(value = "score_awards")
    private Object scoreAwards;

    /**
     * 评价得分
     */
    @TableField(value = "score_evaluate")
    private Object scoreEvaluate;

    /**
     * 合作历史得分
     */
    @TableField(value = "score_join_time")
    private Object scoreJoinTime;

    /**
     * 信用得分
     */
    @TableField(value = "score_credit")
    private Object scoreCredit;

    /**
     * 创建部门
     */
    @TableField(value = "create_dept")
    private String createDept;

    /**
     * 租户id
     */
    @TableField(value = "tenant_id")
    private String tenantId;

    /**
     * 创建人
     */
    @TableField(value = "CREATE_BY")
    private Long createBy;

    /**
     * 创建时间
     */
    @TableField(value = "CREATE_TIME")
    private Date createTime;

    /**
     * 更新人
     */
    @TableField(value = "UPDATE_BY")
    private Long updateBy;

    /**
     * 更新时间
     */
    @TableField(value = "UPDATE_TIME")
    private Date updateTime;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}
