package org.dromara.zjk.domain;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serial;

/**
 * 专家记录变更历史表对象 zjk_expert_history
 *
 * @author zhangzhou
 * @date 2024-11-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_history")
public class ZjkExpertHistory extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 旧数据
     */
    private String oldData;

    /**
     * 新数据
     */
    private String newData;

    /**
     * 变更字段
     */
    private String modifiedFields;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    private Long deleteFlag;

    private Long expectId;

}
