package org.dromara.zjk.domain.bo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import org.dromara.zjk.domain.ZjkExpertMoneyConfig;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

import java.util.List;
import java.util.Set;

/**
 * 专家费用管理业务对象 zjk_expert_money_config
 *
 * @author by
 * @date 2024-11-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertMoneyConfig.class, reverseConvertGenerate = false)
public class ZjkExpertMoneyConfigBo extends BaseEntity {
    /**
     * money_id
     */

    private Long moneyId;
    /**
     * 专家费用标准类型(引用字典money_type)
     */
    private String moneyType;

    /**
     * 专家费用周期
     */
    private String moneyCycle;

    /**
     * 专家计费方式
     */
    private String moneyMethod;

    /**
     * 专家费用
     */
    private Long moneyNumber;

    /**
     * 备注
     */
    private String remark;


    private Set<String> moneyTypeSet;

}
