package org.dromara.zjk.learning_world.domain.bo;


import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningTool;

/**
 * 学习工具管理业务对象 zjk_learning_tool
 *
 * @author ygh
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningTool.class, reverseConvertGenerate = false)
public class ZjkLearningToolBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = {EditGroup.class })
    private Long id;

    /**
     * 工具名称
     */
    @NotBlank(message = "工具名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String name;

    /**
     * 附件
     */
    @NotBlank(message = "附件不能为空", groups = { AddGroup.class, EditGroup.class })
    private String attachment;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;


}
