package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.domain.bo.ZjkProjectEvaluationBo;
import org.dromara.zjk.domain.vo.ZjkProjectEvaluationVo;

import java.util.Collection;
import java.util.List;

/**
 * 项目总结评价Service接口
 *
 * @author ygh
 * @date 2024-11-08
 */
public interface IZjkProjectEvaluationService {

    /**
     * 查询项目总结评价
     *
     * @param id 主键
     * @return 项目总结评价
     */
    org.dromara.zjk.domain.vo.ZjkProjectEvaluationVo queryById(Long id);

    /**
     * 分页查询项目总结评价列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 项目总结评价分页列表
     */
    TableDataInfo<ZjkProjectEvaluationVo> queryPageList(ZjkProjectEvaluationBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的项目总结评价列表
     *
     * @param bo 查询条件
     * @return 项目总结评价列表
     */
    List<ZjkProjectEvaluationVo> queryList(ZjkProjectEvaluationBo bo);

    /**
     * 新增项目总结评价
     *
     * @param bo 项目总结评价
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProjectEvaluationBo bo);

    /**
     * 修改项目总结评价
     *
     * @param bo 项目总结评价
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProjectEvaluationBo bo);

    /**
     * 校验并批量删除项目总结评价信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
