package org.dromara.zjk.zwy.aspect;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.dromara.zjk.zwy.service.SensitiveDataService;
import org.springframework.stereotype.Component;

@Slf4j
@Aspect
@Component
@RequiredArgsConstructor
public class SensitiveEncryptAspect {

    private final SensitiveDataService sensitiveDataService;

    /** 加密切点 */
    @Pointcut("@annotation(org.dromara.zjk.zwy.annotation.EncryptOperation)")
    public void encryptPointcut() {}

    /** 解密切点 */
    @Pointcut("@annotation(org.dromara.zjk.zwy.annotation.DecryptOperation)")
    public void decryptPointcut() {}

    /** 加密执行前 */
    @Before("encryptPointcut()")
    public void beforeEncrypt(JoinPoint joinPoint) {
        log.info("=== beforeEncrypt AOP triggered for method: {}", joinPoint.getSignature());
        for (Object arg : joinPoint.getArgs()) {
            sensitiveDataService.encryptSensitiveFields(arg);
        }
    }

    /** 解密执行后 */
    @AfterReturning(pointcut = "decryptPointcut()", returning = "result")
    public void afterDecrypt(JoinPoint joinPoint, Object result) {
        sensitiveDataService.decryptSensitiveFields(result);
    }
}

