/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.reactive;

import com.tongweb.container.startup.ServletContainer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebReactiveWebServerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

abstract class ReactiveWebServerFactoryConfiguration {
    ReactiveWebServerFactoryConfiguration() {
    }

    @Configuration
    @ConditionalOnMissingBean(value={ReactiveWebServerFactory.class})
    @ConditionalOnClass(value={ServletContainer.class})
    static class EmbeddedTongWeb {
        EmbeddedTongWeb() {
        }

        @Bean
        TongWebReactiveWebServerFactory tongWebReactiveWebServerFactory(ObjectProvider<TongWebConnectorCustomizer> connectorCustomizers, ObjectProvider<TongWebContextCustomizer> contextCustomizers, ObjectProvider<TongWebProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
            TongWebReactiveWebServerFactory factory = new TongWebReactiveWebServerFactory();
            factory.getTongWebConnectorCustomizers().addAll(connectorCustomizers.orderedStream().toList());
            factory.getTongWebContextCustomizers().addAll(contextCustomizers.orderedStream().toList());
            factory.getTongWebProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().toList());
            return factory;
        }
    }
}

