/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure.web.servlet;

import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.TongWebConfig;
import com.tongweb.springboot.web.embedded.tongweb.ConfigurableTongWebWebServerFactory;
import com.tongweb.springboot.web.embedded.tongweb.TongWebServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.ObjectUtils;

public class TongWebServletWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<TongWebServletWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    public TongWebServletWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public int getOrder() {
        return 1;
    }

    public void customize(TongWebServletWebServerFactory factory) {
        factory.setPort(this.serverProperties.getPort());
        TongWebConfig tongWebEmbedded = this.serverProperties.getTongweb();
        if (!ObjectUtils.isEmpty(tongWebEmbedded.getAdditionalTldSkipPatterns())) {
            factory.getTldSkipPatterns().addAll(tongWebEmbedded.getAdditionalTldSkipPatterns());
        }
        if (tongWebEmbedded.getRedirectContextRoot() != null) {
            this.customizeRedirectContextRoot(factory, tongWebEmbedded.getRedirectContextRoot());
        }
        this.customizeUseRelativeRedirects(factory, tongWebEmbedded.isUseRelativeRedirects());
        factory.setDisableMBeanRegistry(!tongWebEmbedded.getMbeanregistry().isEnabled());
    }

    private void customizeRedirectContextRoot(ConfigurableTongWebWebServerFactory factory, boolean redirectContextRoot) {
        factory.addContextCustomizers(context -> context.setMapperContextRootRedirectEnabled(redirectContextRoot));
    }

    private void customizeUseRelativeRedirects(ConfigurableTongWebWebServerFactory factory, boolean useRelativeRedirects) {
        factory.addContextCustomizers(context -> context.setUseRelativeRedirects(useRelativeRedirects));
    }
}

