/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.web.embedded.tongweb;

import com.tongweb.commons.license.LicenseSDKProvider;
import com.tongweb.commons.utils.SystemExitUtil;
import com.tongweb.connector.AbstractProtocol;
import com.tongweb.connector.ProtocolHandler;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.connector.http2.Http2Protocol;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Loader;
import com.tongweb.container.Manager;
import com.tongweb.container.Valve;
import com.tongweb.container.WebResource;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.Wrapper;
import com.tongweb.container.connector.Connector;
import com.tongweb.container.core.AprLifecycleListener;
import com.tongweb.container.loader.WebappClassLoaderBase;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.session.StandardManager;
import com.tongweb.container.startup.ServletContainer;
import com.tongweb.container.util.LifecycleBase;
import com.tongweb.container.util.ServerInfo;
import com.tongweb.container.util.SessionConfig;
import com.tongweb.container.webresources.AbstractResourceSet;
import com.tongweb.container.webresources.EmptyResource;
import com.tongweb.container.webresources.StandardRoot;
import com.tongweb.springboot.autoconfigure.web.ServerProperties;
import com.tongweb.springboot.autoconfigure.web.TongWebConfig;
import com.tongweb.springboot.autoconfigure.web.properties.RemoteFilterConfigBean;
import com.tongweb.springboot.web.embedded.tongweb.CompressionConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.ConfigurableTongWebWebServerFactory;
import com.tongweb.springboot.web.embedded.tongweb.DisableReferenceClearingContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.SslConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TldPatterns;
import com.tongweb.springboot.web.embedded.tongweb.TongWebConnectorCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebContextCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedContext;
import com.tongweb.springboot.web.embedded.tongweb.TongWebEmbeddedWebappClassLoader;
import com.tongweb.springboot.web.embedded.tongweb.TongWebProtocolHandlerCustomizer;
import com.tongweb.springboot.web.embedded.tongweb.TongWebStarter;
import com.tongweb.springboot.web.embedded.tongweb.TongWebWebServer;
import com.tongweb.web.JarScanFilter;
import com.tongweb.web.util.http.CookieProcessor;
import com.tongweb.web.util.http.Rfc6265CookieProcessor;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.scan.StandardJarScanFilter;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.boot.web.server.Cookie;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.boot.web.servlet.server.CookieSameSiteSupplier;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TongWebServletWebServerFactory
extends AbstractServletWebServerFactory
implements ConfigurableTongWebWebServerFactory,
ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    public static final String DEFAULT_PROTOCOL = "com.tongweb.connector.http11.Http11NioProtocol";
    private File baseDirectory;
    private List<Valve> engineValves = new ArrayList<Valve>();
    private List<Valve> hostValves = new ArrayList<Valve>();
    private List<Valve> contextValves = new ArrayList<Valve>();
    private Valve semaphore;
    private RemoteFilterConfigBean remoteFilter;
    private List<LifecycleListener> contextLifecycleListeners = new ArrayList<LifecycleListener>();
    private final List<LifecycleListener> serverLifecycleListeners = TongWebServletWebServerFactory.getDefaultServerLifecycleListeners();
    private Set<TongWebContextCustomizer> tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>();
    private Set<TongWebConnectorCustomizer> tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>();
    private Set<TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizers = new LinkedHashSet();
    private final List<Connector> additionalTongWebConnectors = new ArrayList<Connector>();
    private ResourceLoader resourceLoader;
    private String protocol = "com.tongweb.connector.http11.Http11NioProtocol";
    private Set<String> tldSkipPatterns = new LinkedHashSet<String>(TldPatterns.DEFAULT_SKIP);
    private final Set<String> tldScanPatterns = new LinkedHashSet<String>(TldPatterns.DEFAULT_SCAN);
    private Charset uriEncoding = DEFAULT_CHARSET;
    private int backgroundProcessorDelay;
    private boolean disableMBeanRegistry = true;
    private List<String> notAllowHttpMethods = new ArrayList<String>();
    private TongWebConfig tongWebConfig;
    @Autowired
    private ApplicationContext context;
    private Jsp jsp = new Jsp();

    public TongWebServletWebServerFactory() {
    }

    public TongWebServletWebServerFactory(int port) {
        super(port);
    }

    public TongWebServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
    }

    private static List<LifecycleListener> getDefaultServerLifecycleListeners() {
        ArrayList<LifecycleListener> lifecycleListeners = new ArrayList<LifecycleListener>();
        if (!NativeDetector.inNativeImage()) {
            AprLifecycleListener aprLifecycleListener = new AprLifecycleListener();
            if (AprLifecycleListener.isAprAvailable()) {
                lifecycleListeners.add((LifecycleListener)aprLifecycleListener);
            }
        }
        return lifecycleListeners;
    }

    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        this.addExitHook();
        this.processLicenseValidateConfig();
        if (this.disableMBeanRegistry) {
            Registry.disableRegistry();
        }
        ServletContainer servletContainer = new ServletContainer();
        File baseDir = this.baseDirectory != null ? this.baseDirectory : this.createTempDir("tongweb");
        servletContainer.setBaseDir(baseDir.getAbsolutePath());
        for (LifecycleListener listener : this.serverLifecycleListeners) {
            servletContainer.getServer().addLifecycleListener(listener);
        }
        Connector connector = new Connector(this.protocol);
        connector.setThrowOnFailure(true);
        servletContainer.getService().addConnector(connector);
        this.customizeConnector(connector);
        servletContainer.setConnector(connector);
        servletContainer.getHost().setAutoDeploy(false);
        this.configureEngine(servletContainer.getEngine());
        this.configHostValves(servletContainer.getHost());
        for (Connector additionalConnector : this.additionalTongWebConnectors) {
            servletContainer.getService().addConnector(additionalConnector);
        }
        this.prepareContext(servletContainer.getHost(), initializers);
        return this.getTongWebWebServer(servletContainer);
    }

    private void configHostValves(Host host) {
        for (Valve valve : this.hostValves) {
            host.getPipeline().addValve(valve);
        }
    }

    private void addExitHook() {
        SystemExitUtil.setHook(() -> System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0})));
    }

    private void processLicenseValidateConfig() {
        ServerInfo.getServerENumber();
        PropertyMapper propertyMapper = PropertyMapper.get();
        String validType = this.tongWebConfig.getLicense().getType();
        String licensePath = this.tongWebConfig.getLicense().getPath();
        Boolean isSync = this.tongWebConfig.getLicense().isSync();
        System.setProperty("server.tongweb.license.type", validType);
        System.setProperty("server.tongweb.license.filePath", licensePath);
        System.setProperty("server.tongweb.license.isSync", isSync.toString());
        propertyMapper.from((Object)this.tongWebConfig.getLicense().getLicenseIps()).whenHasText().to(this::putLicenseIps);
        propertyMapper.from((Object)this.tongWebConfig.getLicense().getLicensePublicKey()).whenHasText().to(this::putPublicKey);
        if (this.tongWebConfig.getLicense().getSsl() != null) {
            propertyMapper.from((Object)this.tongWebConfig.getLicense().isSslEnabled()).whenNonNull().to(this::pusSslEnabled);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getKeyStore()).whenHasText().to(this::putKeyStore);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getKeyStorePassword()).whenHasText().to(this::putKeyStorePassword);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getKeyStoreType()).whenHasText().to(this::putKeyStoreType);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getTrustStore()).whenHasText().to(this::putTrustStore);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getTrustStorePassword()).whenHasText().to(this::putTrustStorePassword);
            propertyMapper.from((Object)this.tongWebConfig.getLicense().getSsl().getTrustStoreType()).whenHasText().to(this::putTrustStoreType);
        }
        LicenseSDKProvider.validate();
    }

    private void putLicenseIps(String value) {
        System.setProperty("server.tongweb.license.license-ips", value);
    }

    private void putPublicKey(String value) {
        System.setProperty("server.tongweb.license.publicKey", value);
    }

    private void pusSslEnabled(boolean value) {
        System.setProperty("server.tongweb.license.ssl.enabled", String.valueOf(value));
    }

    private void putKeyStore(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStore", value);
    }

    private void putKeyStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStorePassword", value);
    }

    private void putKeyStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.keyStoreType", value);
    }

    private void putTrustStore(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStore", value);
    }

    private void putTrustStorePassword(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStorePassword", value);
    }

    private void putTrustStoreType(String value) {
        System.setProperty("server.tongweb.license.ssl.trustStoreType", value);
    }

    private void configureEngine(Engine engine) {
        engine.setBackgroundProcessorDelay(this.backgroundProcessorDelay);
        for (Valve valve : this.engineValves) {
            engine.getPipeline().addValve(valve);
        }
    }

    protected void prepareContext(Host host, ServletContextInitializer[] initializers) {
        File documentRoot = this.getValidDocumentRoot();
        TongWebEmbeddedContext context = new TongWebEmbeddedContext();
        if (documentRoot != null) {
            context.setResources((WebResourceRoot)new LoaderHidingResourceRoot(context));
        }
        context.setName(this.getContextPath());
        context.setDisplayName(this.getDisplayName());
        context.setPath(this.getContextPath());
        File docBase = documentRoot != null ? documentRoot : this.createTempDir("tongweb-docbase");
        context.setDocBase(docBase.getAbsolutePath());
        context.addLifecycleListener((LifecycleListener)new ServletContainer.FixContextListener());
        ClassLoader parentClassLoader = this.resourceLoader != null ? this.resourceLoader.getClassLoader() : ClassUtils.getDefaultClassLoader();
        context.setParentClassLoader(parentClassLoader);
        this.resetDefaultLocaleMapping(context);
        this.addLocaleMappings(context);
        try {
            context.setCreateUploadTargets(true);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.configureTldPatterns(context);
        WebappLoader loader = new WebappLoader();
        loader.setLoaderInstance((WebappClassLoaderBase)new TongWebEmbeddedWebappClassLoader(parentClassLoader));
        loader.setDelegate(true);
        context.setLoader((Loader)loader);
        if (this.isRegisterDefaultServlet()) {
            this.addDefaultServlet((Context)context);
        }
        if (this.shouldRegisterJspServlet()) {
            this.addJspServlet((Context)context);
            this.addJasperInitializer(context);
        }
        context.addLifecycleListener(new StaticResourceConfigurer((Context)context));
        ServletContextInitializer[] initializersToUse = this.mergeInitializers(initializers);
        host.addChild((Container)context);
        this.configureContext((Context)context, initializersToUse);
        this.postProcessContext((Context)context);
    }

    public Jsp getJsp() {
        return this.jsp;
    }

    public void setJsp(Jsp jsp) {
        this.jsp = jsp;
    }

    protected boolean shouldRegisterJspServlet() {
        this.jsp.setClassName("com.tongweb.jasper.servlet.JspServlet");
        return this.jsp != null && this.jsp.getRegistered() && ClassUtils.isPresent((String)this.jsp.getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }

    private void resetDefaultLocaleMapping(TongWebEmbeddedContext context) {
        context.addLocaleEncodingMappingParameter(Locale.ENGLISH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.FRENCH.toString(), DEFAULT_CHARSET.displayName());
        context.addLocaleEncodingMappingParameter(Locale.JAPANESE.toString(), DEFAULT_CHARSET.displayName());
    }

    private void addLocaleMappings(TongWebEmbeddedContext context) {
        this.getLocaleCharsetMappings().forEach((locale, charset) -> context.addLocaleEncodingMappingParameter(locale.toString(), charset.toString()));
    }

    private void configureTldPatterns(TongWebEmbeddedContext context) {
        StandardJarScanFilter filter = new StandardJarScanFilter();
        filter.setTldSkip(StringUtils.collectionToCommaDelimitedString(this.tldSkipPatterns));
        filter.setTldScan(StringUtils.collectionToCommaDelimitedString(this.tldScanPatterns));
        context.getJarScanner().setJarScanFilter((JarScanFilter)filter);
    }

    private void addDefaultServlet(Context context) {
        Wrapper defaultServlet = context.createWrapper();
        defaultServlet.setName("default");
        defaultServlet.setServletClass("com.tongweb.container.servlets.DefaultServlet");
        defaultServlet.addInitParameter("debug", "0");
        defaultServlet.addInitParameter("listings", "false");
        defaultServlet.setLoadOnStartup(1);
        defaultServlet.setOverridable(true);
        context.addChild((Container)defaultServlet);
        context.addServletMappingDecoded("/", "default");
    }

    private void addJspServlet(Context context) {
        Wrapper jspServlet = context.createWrapper();
        jspServlet.setName("jsp");
        jspServlet.setServletClass(this.getJsp().getClassName());
        jspServlet.addInitParameter("fork", "false");
        this.getJsp().getInitParameters().forEach((arg_0, arg_1) -> ((Wrapper)jspServlet).addInitParameter(arg_0, arg_1));
        jspServlet.setLoadOnStartup(3);
        context.addChild((Container)jspServlet);
        context.addServletMappingDecoded("*.jsp", "jsp");
        context.addServletMappingDecoded("*.jspx", "jsp");
    }

    private void addJasperInitializer(TongWebEmbeddedContext context) {
        try {
            ServletContainerInitializer initializer = (ServletContainerInitializer)ClassUtils.forName((String)"com.tongweb.jasper.servlet.JasperInitializer", null).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            context.addServletContainerInitializer(initializer, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void customizeConnector(Connector connector) {
        if (this.notAllowHttpMethods.contains("TRACE") || this.notAllowHttpMethods.contains("trace") || !this.tongWebConfig.getAllowTrace().booleanValue()) {
            connector.setAllowTrace(false);
        } else {
            connector.setAllowTrace(true);
        }
        int port = Math.max(this.getPort(), 0);
        connector.setPort(port);
        if (StringUtils.hasText((String)this.getServerHeader())) {
            connector.setProperty("server", this.getServerHeader());
        }
        if (connector.getProtocolHandler() instanceof AbstractProtocol) {
            this.customizeProtocol((AbstractProtocol)connector.getProtocolHandler());
        }
        this.invokeProtocolHandlerCustomizers(connector.getProtocolHandler());
        if (this.getUriEncoding() != null) {
            connector.setURIEncoding(this.getUriEncoding().name());
        }
        connector.setProperty("bindOnInit", "false");
        if (this.getHttp2() != null && this.getHttp2().isEnabled()) {
            connector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(connector);
        }
        CompressionConnectorCustomizer compression = new CompressionConnectorCustomizer(this.getCompression());
        compression.customize(connector);
        for (TongWebConnectorCustomizer customizer : this.tongWebConnectorCustomizers) {
            customizer.customize(connector);
        }
    }

    private void customizeProtocol(AbstractProtocol<?> protocol) {
        if (this.getAddress() != null) {
            protocol.setAddress(this.getAddress());
        }
    }

    private void invokeProtocolHandlerCustomizers(ProtocolHandler protocolHandler) {
        LambdaSafe.callbacks(TongWebProtocolHandlerCustomizer.class, this.tongWebProtocolHandlerCustomizers, (Object)protocolHandler, (Object[])new Object[0]).invoke(customizer -> customizer.customize(protocolHandler));
    }

    private void customizeSsl(Connector connector) {
        new SslConnectorCustomizer(this.getSsl(), this.getOrCreateSslStoreProvider()).customize(connector);
    }

    protected void configureContext(Context context, ServletContextInitializer[] initializers) {
        TongWebStarter starter = new TongWebStarter(initializers);
        if (context instanceof TongWebEmbeddedContext) {
            TongWebEmbeddedContext embeddedContext = (TongWebEmbeddedContext)context;
            embeddedContext.setStarter(starter);
            embeddedContext.setFailCtxIfServletStartFails(true);
        }
        context.addServletContainerInitializer((ServletContainerInitializer)starter, NO_CLASSES);
        for (LifecycleListener lifecycleListener : this.contextLifecycleListeners) {
            context.addLifecycleListener(lifecycleListener);
        }
        for (Valve valve : this.contextValves) {
            context.getPipeline().addValve(valve);
        }
        for (ErrorPage errorPage : this.getErrorPages()) {
            com.tongweb.web.util.descriptor.web.ErrorPage tongWebErrorPage = new com.tongweb.web.util.descriptor.web.ErrorPage();
            tongWebErrorPage.setLocation(errorPage.getPath());
            tongWebErrorPage.setErrorCode(errorPage.getStatusCode());
            tongWebErrorPage.setExceptionType(errorPage.getExceptionName());
            context.addErrorPage(tongWebErrorPage);
        }
        this.setMimeMappings(context);
        this.configureSession(context);
        this.configureCookieProcessor(context);
        this.configureResources(context);
        new DisableReferenceClearingContextCustomizer().customize(context);
        for (String webListenerClassName : this.getWebListenerClassNames()) {
            context.addApplicationListener(webListenerClassName);
        }
        for (TongWebContextCustomizer customizer : this.tongWebContextCustomizers) {
            customizer.customize(context);
        }
    }

    private void configureResources(Context context) {
        WebResourceRoot resourceRoot = context.getResources();
        if (Objects.isNull(resourceRoot)) {
            resourceRoot = new StandardRoot(context);
        }
        resourceRoot.setCachingAllowed(this.tongWebConfig.getResource().isAllowCaching());
        resourceRoot.setCacheObjectMaxSize(this.tongWebConfig.getResource().getCacheObjectMaxSize().intValue());
        resourceRoot.setCacheMaxSize(this.tongWebConfig.getResource().getCacheMaxSize());
        long ttl = this.tongWebConfig.getResource().getCacheTtl().toMillis();
        resourceRoot.setCacheTtl(ttl);
        context.setResources(resourceRoot);
    }

    private void configureSession(Context context) {
        long sessionTimeout = this.getSessionTimeoutInMinutes();
        context.setSessionTimeout((int)sessionTimeout);
        Boolean httpOnly = this.getSession().getCookie().getHttpOnly();
        if (httpOnly != null) {
            context.setUseHttpOnly(httpOnly.booleanValue());
        }
        if (this.getSession().isPersistent()) {
            Manager manager = context.getManager();
            if (manager == null) {
                manager = new StandardManager();
                context.setManager(manager);
            }
            this.configurePersistSession(manager);
        } else {
            context.addLifecycleListener((LifecycleListener)new DisablePersistSessionListener());
        }
    }

    private void setMimeMappings(Context context) {
        if (context instanceof TongWebEmbeddedContext) {
            TongWebEmbeddedContext embeddedContext = (TongWebEmbeddedContext)context;
            embeddedContext.setMimeMappings(this.getMimeMappings());
            return;
        }
        for (MimeMappings.Mapping mapping : this.getMimeMappings()) {
            context.addMimeMapping(mapping.getExtension(), mapping.getMimeType());
        }
    }

    private void configureCookieProcessor(Context context) {
        Cookie.SameSite sessionSameSite = this.getSession().getCookie().getSameSite();
        ArrayList<CookieSameSiteSupplier> suppliers = new ArrayList<CookieSameSiteSupplier>();
        if (sessionSameSite != null) {
            suppliers.add(CookieSameSiteSupplier.of((Cookie.SameSite)sessionSameSite).whenHasName(() -> SessionConfig.getSessionCookieName((Context)context)));
        }
        if (!CollectionUtils.isEmpty((Collection)this.getCookieSameSiteSuppliers())) {
            suppliers.addAll(this.getCookieSameSiteSuppliers());
        }
        if (!suppliers.isEmpty()) {
            context.setCookieProcessor((CookieProcessor)new SuppliedSameSiteCookieProcessor(suppliers));
        }
    }

    private void configurePersistSession(Manager manager) {
        Assert.state((boolean)(manager instanceof StandardManager), () -> "Unable to persist HTTP session state using manager type " + manager.getClass().getName());
        File dir = this.getValidSessionStoreDir();
        File file = new File(dir, "SESSIONS.ser");
        ((StandardManager)manager).setPathname(file.getAbsolutePath());
    }

    private long getSessionTimeoutInMinutes() {
        Duration sessionTimeout = this.getSession().getTimeout();
        if (this.isZeroOrLess(sessionTimeout)) {
            return 0L;
        }
        return Math.max(sessionTimeout.toMinutes(), 1L);
    }

    private boolean isZeroOrLess(Duration sessionTimeout) {
        return sessionTimeout == null || sessionTimeout.isNegative() || sessionTimeout.isZero();
    }

    protected void postProcessContext(Context context) {
    }

    protected TongWebWebServer getTongWebWebServer(ServletContainer servletContainer) {
        return new TongWebWebServer(servletContainer, this.getPort() >= 0, this.getShutdown());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public Set<String> getTldSkipPatterns() {
        return this.tldSkipPatterns;
    }

    public void setTldSkipPatterns(Collection<String> patterns) {
        Assert.notNull(patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns = new LinkedHashSet<String>(patterns);
    }

    public void addTldSkipPatterns(String ... patterns) {
        Assert.notNull((Object)patterns, (String)"Patterns must not be null");
        this.tldSkipPatterns.addAll(Arrays.asList(patterns));
    }

    public void setProtocol(String protocol) {
        Assert.hasLength((String)protocol, (String)"Protocol must not be empty");
        this.protocol = protocol;
    }

    public void setEngineValves(Collection<? extends Valve> engineValves) {
        Assert.notNull(engineValves, (String)"Valves must not be null");
        this.engineValves = new ArrayList<Valve>(engineValves);
    }

    public Collection<Valve> getEngineValves() {
        return this.engineValves;
    }

    @Override
    public void addEngineValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.engineValves.addAll(Arrays.asList(engineValves));
    }

    public void addHostValves(Valve ... engineValves) {
        Assert.notNull((Object)engineValves, (String)"Valves must not be null");
        this.hostValves.addAll(Arrays.asList(engineValves));
    }

    public void setContextValves(Collection<? extends Valve> contextValves) {
        Assert.notNull(contextValves, (String)"Valves must not be null");
        this.contextValves = new ArrayList<Valve>(contextValves);
    }

    public Collection<Valve> getContextValves() {
        return this.contextValves;
    }

    public void addContextValves(Valve ... contextValves) {
        Assert.notNull((Object)contextValves, (String)"Valves must not be null");
        this.contextValves.addAll(Arrays.asList(contextValves));
    }

    public RemoteFilterConfigBean getRemoteFilter() {
        return this.remoteFilter;
    }

    public void setRemoteFilter(RemoteFilterConfigBean remoteFilter) {
        this.remoteFilter = remoteFilter;
    }

    public void setContextLifecycleListeners(Collection<? extends LifecycleListener> contextLifecycleListeners) {
        Assert.notNull(contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners = new ArrayList<LifecycleListener>(contextLifecycleListeners);
    }

    public Collection<LifecycleListener> getContextLifecycleListeners() {
        return this.contextLifecycleListeners;
    }

    public void addContextLifecycleListeners(LifecycleListener ... contextLifecycleListeners) {
        Assert.notNull((Object)contextLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.contextLifecycleListeners.addAll(Arrays.asList(contextLifecycleListeners));
    }

    public Collection<LifecycleListener> getServerLifecycleListeners() {
        return this.serverLifecycleListeners;
    }

    public void addServerLifecycleListeners(LifecycleListener ... serverLifecycleListeners) {
        Assert.notNull((Object)serverLifecycleListeners, (String)"ContextLifecycleListeners must not be null");
        this.serverLifecycleListeners.addAll(Arrays.asList(serverLifecycleListeners));
    }

    public void setTongWebContextCustomizers(Collection<? extends TongWebContextCustomizer> tongWebContextCustomizers) {
        Assert.notNull(tongWebContextCustomizers, (String)"TongWebContextCustomizers must not be null");
        this.tongWebContextCustomizers = new LinkedHashSet<TongWebContextCustomizer>(tongWebContextCustomizers);
    }

    public Collection<TongWebContextCustomizer> getTongWebContextCustomizers() {
        return this.tongWebContextCustomizers;
    }

    @Override
    public void addContextCustomizers(TongWebContextCustomizer ... tongWebContextCustomizers) {
        Assert.notNull((Object)tongWebContextCustomizers, (String)"TongWebContextCustomizers must not be null");
        this.tongWebContextCustomizers.addAll(Arrays.asList(tongWebContextCustomizers));
    }

    public void setTongWebConnectorCustomizers(Collection<? extends TongWebConnectorCustomizer> tongWebConnectorCustomizers) {
        Assert.notNull(tongWebConnectorCustomizers, (String)"TongWebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers = new LinkedHashSet<TongWebConnectorCustomizer>(tongWebConnectorCustomizers);
    }

    @Override
    public void addConnectorCustomizers(TongWebConnectorCustomizer ... tongWebConnectorCustomizers) {
        Assert.notNull((Object)tongWebConnectorCustomizers, (String)"TongWebConnectorCustomizers must not be null");
        this.tongWebConnectorCustomizers.addAll(Arrays.asList(tongWebConnectorCustomizers));
    }

    public Collection<TongWebConnectorCustomizer> getTongWebConnectorCustomizers() {
        return this.tongWebConnectorCustomizers;
    }

    public void setTongWebProtocolHandlerCustomizers(Collection<? extends TongWebProtocolHandlerCustomizer<?>> tongWebProtocolHandlerCustomizer) {
        Assert.notNull(tongWebProtocolHandlerCustomizer, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers = new LinkedHashSet(tongWebProtocolHandlerCustomizer);
    }

    @Override
    public void addProtocolHandlerCustomizers(TongWebProtocolHandlerCustomizer<?> ... tongWebProtocolHandlerCustomizers) {
        Assert.notNull(tongWebProtocolHandlerCustomizers, (String)"TongWebProtocolHandlerCustomizers must not be null");
        this.tongWebProtocolHandlerCustomizers.addAll(Arrays.asList(tongWebProtocolHandlerCustomizers));
    }

    public Collection<TongWebProtocolHandlerCustomizer<?>> getTongWebProtocolHandlerCustomizers() {
        return this.tongWebProtocolHandlerCustomizers;
    }

    public void addAdditionalTongWebConnectors(Connector ... connectors) {
        Assert.notNull((Object)connectors, (String)"Connectors must not be null");
        this.additionalTongWebConnectors.addAll(Arrays.asList(connectors));
    }

    public List<Connector> getAdditionalTongWebConnectors() {
        return this.additionalTongWebConnectors;
    }

    @Override
    public void setUriEncoding(Charset uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    @Override
    @Autowired
    public void setServerProperties(ServerProperties serverProperties) {
        this.tongWebConfig = serverProperties.getTongweb();
    }

    public Charset getUriEncoding() {
        return this.uriEncoding;
    }

    @Override
    public void setBackgroundProcessorDelay(int delay) {
        this.backgroundProcessorDelay = delay;
    }

    public void setDisableMBeanRegistry(boolean disableMBeanRegistry) {
        this.disableMBeanRegistry = disableMBeanRegistry;
    }

    public List<String> getNotAllowHttpMethods() {
        return this.notAllowHttpMethods;
    }

    public void setNotAllowHttpMethods(List<String> notAllowHttpMethods) {
        this.notAllowHttpMethods = notAllowHttpMethods;
    }

    public Valve getSemaphore() {
        return this.semaphore;
    }

    public void setSemaphore(Valve semaphore) {
        this.semaphore = semaphore;
    }

    private static final class LoaderHidingResourceRoot
    extends StandardRoot {
        private LoaderHidingResourceRoot(TongWebEmbeddedContext context) {
            super((Context)context);
        }

        protected WebResourceSet createMainResourceSet() {
            return new LoaderHidingWebResourceSet(super.createMainResourceSet());
        }
    }

    private final class StaticResourceConfigurer
    implements LifecycleListener {
        private final Context context;

        private StaticResourceConfigurer(Context context) {
            this.context = context;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if (event.getType().equals("configure_start")) {
                this.addResourceJars(TongWebServletWebServerFactory.this.getUrlsOfJarsWithMetaInfResources());
            }
        }

        private void addResourceJars(List<URL> resourceJarUrls) {
            for (URL url : resourceJarUrls) {
                String path = url.getPath();
                if (path.endsWith(".jar") || path.endsWith(".jar!/")) {
                    Object jar = url.toString();
                    if (!((String)jar).startsWith("jar:")) {
                        jar = "jar:" + (String)jar + "!/";
                    }
                    this.addResourceSet((String)jar);
                    continue;
                }
                this.addResourceSet(url.toString());
            }
        }

        private void addResourceSet(String resource) {
            try {
                if (this.isInsideNestedJar(resource)) {
                    resource = resource.substring(0, resource.length() - 2);
                }
                URL url = new URL(resource);
                String path = "/META-INF/resources";
                this.context.getResources().createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", url, path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private boolean isInsideNestedJar(String dir) {
            return dir.indexOf("!/") < dir.lastIndexOf("!/");
        }
    }

    private static class DisablePersistSessionListener
    implements LifecycleListener {
        private DisablePersistSessionListener() {
        }

        public void lifecycleEvent(LifecycleEvent event) {
            Context context;
            Manager manager;
            if (event.getType().equals("start") && (manager = (context = (Context)event.getLifecycle()).getManager()) instanceof StandardManager) {
                StandardManager standardManager = (StandardManager)manager;
                standardManager.setPathname(null);
            }
        }
    }

    private static class SuppliedSameSiteCookieProcessor
    extends Rfc6265CookieProcessor {
        private final List<CookieSameSiteSupplier> suppliers;

        SuppliedSameSiteCookieProcessor(List<CookieSameSiteSupplier> suppliers) {
            this.suppliers = suppliers;
        }

        public String generateHeader(Cookie cookie, HttpServletRequest request) {
            Cookie.SameSite sameSite = this.getSameSite(cookie);
            if (sameSite == null) {
                return super.generateHeader(cookie, request);
            }
            Rfc6265CookieProcessor delegate = new Rfc6265CookieProcessor();
            delegate.setSameSiteCookies(sameSite.attributeValue());
            return delegate.generateHeader(cookie, request);
        }

        private Cookie.SameSite getSameSite(Cookie cookie) {
            for (CookieSameSiteSupplier supplier : this.suppliers) {
                Cookie.SameSite sameSite = supplier.getSameSite(cookie);
                if (sameSite == null) continue;
                return sameSite;
            }
            return null;
        }
    }

    private static final class LoaderHidingWebResourceSet
    extends AbstractResourceSet {
        private final WebResourceSet delegate;
        private final Method initInternal;

        private LoaderHidingWebResourceSet(WebResourceSet delegate) {
            this.delegate = delegate;
            try {
                this.initInternal = LifecycleBase.class.getDeclaredMethod("initInternal", new Class[0]);
                this.initInternal.setAccessible(true);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        public WebResource getResource(String path) {
            if (path.startsWith("/org/springframework/boot")) {
                return new EmptyResource(this.getRoot(), path);
            }
            return this.delegate.getResource(path);
        }

        public String[] list(String path) {
            return this.delegate.list(path);
        }

        public Set<String> listWebAppPaths(String path) {
            return this.delegate.listWebAppPaths(path).stream().filter(webAppPath -> !webAppPath.startsWith("/org/springframework/boot")).collect(Collectors.toSet());
        }

        public boolean mkdir(String path) {
            return this.delegate.mkdir(path);
        }

        public boolean write(String path, InputStream is, boolean overwrite) {
            return this.delegate.write(path, is, overwrite);
        }

        public URL getBaseUrl() {
            return this.delegate.getBaseUrl();
        }

        public void setReadOnly(boolean readOnly) {
            this.delegate.setReadOnly(readOnly);
        }

        public boolean isReadOnly() {
            return this.delegate.isReadOnly();
        }

        public void gc() {
            this.delegate.gc();
        }

        protected void initInternal() throws LifecycleException {
            if (this.delegate instanceof LifecycleBase) {
                try {
                    ReflectionUtils.invokeMethod((Method)this.initInternal, (Object)this.delegate);
                }
                catch (Exception ex) {
                    throw new LifecycleException((Throwable)ex);
                }
            }
        }
    }
}

