/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigPublishResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.ResponseCode;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.MapUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigOperateResult;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class ConfigPublishRequestHandler
extends RequestHandler<ConfigPublishRequest, ConfigPublishResponse> {
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigInfoTagPersistService configInfoTagPersistService;
    private final ConfigInfoBetaPersistService configInfoBetaPersistService;

    public ConfigPublishRequestHandler(ConfigInfoPersistService configInfoPersistService, ConfigInfoTagPersistService configInfoTagPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
    }

    @TpsControl(pointName="ConfigPublish")
    @Secured(action=ActionTypes.WRITE, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigPublishResponse handle(ConfigPublishRequest request, RequestMeta meta) throws NacosException {
        try {
            String dataId = request.getDataId();
            String group = request.getGroup();
            String content = request.getContent();
            String tenant = request.getTenant();
            String srcIp = meta.getClientIp();
            String requestIpApp = request.getAdditionParam("requestIpApp");
            String tag = request.getAdditionParam("tag");
            String appName = request.getAdditionParam("appName");
            String type = request.getAdditionParam("type");
            String srcUser = request.getAdditionParam("src_user");
            String encryptedDataKey = request.getAdditionParam("encryptedDataKey");
            ParamUtils.checkParam(dataId, group, "datumId", content);
            ParamUtils.checkParam(tag);
            HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)request.getAdditionParam("config_tags"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)request.getAdditionParam("desc"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)request.getAdditionParam("use"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)request.getAdditionParam("effect"));
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)type);
            MapUtil.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)request.getAdditionParam("schema"));
            ParamUtils.checkParam(configAdvanceInfo);
            if (AggrWhitelist.isAggrDataId(dataId)) {
                Loggers.REMOTE_DIGEST.warn("[aggr-conflict] {} attempt to publish single data, {}, {}", new Object[]{srcIp, dataId, group});
                throw new NacosException(403, "dataId:" + dataId + " is aggr");
            }
            ConfigInfo configInfo = new ConfigInfo(dataId, group, tenant, appName, content);
            configInfo.setMd5(request.getCasMd5());
            configInfo.setType(type);
            configInfo.setEncryptedDataKey(encryptedDataKey);
            String betaIps = request.getAdditionParam("betaIps");
            ConfigOperateResult configOperateResult = null;
            String persistEvent = "persist";
            if (StringUtils.isBlank((CharSequence)betaIps)) {
                if (StringUtils.isBlank((CharSequence)tag)) {
                    if (StringUtils.isNotBlank((String)request.getCasMd5())) {
                        configOperateResult = this.configInfoPersistService.insertOrUpdateCas(srcIp, srcUser, configInfo, configAdvanceInfo);
                        if (!configOperateResult.isSuccess()) {
                            return ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)"Cas publish fail,server md5 may have changed.");
                        }
                    } else {
                        configOperateResult = this.configInfoPersistService.insertOrUpdate(srcIp, srcUser, configInfo, configAdvanceInfo);
                    }
                    ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, configOperateResult.getLastModified()));
                } else {
                    if (StringUtils.isNotBlank((String)request.getCasMd5())) {
                        configOperateResult = this.configInfoTagPersistService.insertOrUpdateTagCas(configInfo, tag, srcIp, srcUser);
                        if (!configOperateResult.isSuccess()) {
                            return ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)"Cas publish tag config fail,server md5 may have changed.");
                        }
                    } else {
                        configOperateResult = this.configInfoTagPersistService.insertOrUpdateTag(configInfo, tag, srcIp, srcUser);
                    }
                    persistEvent = "persist-tag-" + tag;
                    ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, configOperateResult.getLastModified()));
                }
            } else {
                if (StringUtils.isNotBlank((String)request.getCasMd5())) {
                    configOperateResult = this.configInfoBetaPersistService.insertOrUpdateBetaCas(configInfo, betaIps, srcIp, srcUser);
                    if (!configOperateResult.isSuccess()) {
                        return ConfigPublishResponse.buildFailResponse((int)ResponseCode.FAIL.getCode(), (String)"Cas publish beta config fail,server md5 may have changed.");
                    }
                } else {
                    configOperateResult = this.configInfoBetaPersistService.insertOrUpdateBeta(configInfo, betaIps, srcIp, srcUser);
                }
                persistEvent = "persist-beta";
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(true, dataId, group, tenant, configOperateResult.getLastModified()));
            }
            ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, configOperateResult.getLastModified(), srcIp, persistEvent, "pub", content);
            return ConfigPublishResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("[ConfigPublishRequestHandler] publish config error ,request ={}", (Object)request, (Object)e);
            return ConfigPublishResponse.buildFailResponse((int)(e instanceof NacosException ? ((NacosException)((Object)e)).getErrCode() : ResponseCode.FAIL.getCode()), (String)e.getMessage());
        }
    }
}

