/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.trace;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.constant.Constants;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class ConfigTraceService {
    public static final String PERSISTENCE_EVENT = "persist";
    public static final String PERSISTENCE_EVENT_BETA = "persist-beta";
    public static final String PERSISTENCE_EVENT_BATCH = "persist-batch";
    public static final String PERSISTENCE_EVENT_TAG = "persist-tag";
    public static final String PERSISTENCE_TYPE_PUB = "pub";
    public static final String PERSISTENCE_TYPE_REMOVE = "remove";
    public static final String PERSISTENCE_TYPE_MERGE = "merge";
    public static final String NOTIFY_EVENT = "notify";
    public static final String NOTIFY_EVENT_BETA = "notify-beta";
    public static final String NOTIFY_EVENT_BATCH = "notify-batch";
    public static final String NOTIFY_EVENT_TAG = "notify-tag";
    public static final String NOTIFY_TYPE_OK = "ok";
    public static final String NOTIFY_TYPE_ERROR = "error";
    public static final String NOTIFY_TYPE_UNHEALTH = "unhealth";
    public static final String NOTIFY_TYPE_EXCEPTION = "exception";
    public static final String DUMP_EVENT = "dump";
    public static final String DUMP_EVENT_BETA = "dump-beta";
    public static final String DUMP_EVENT_BATCH = "dump-batch";
    public static final String DUMP_EVENT_TAG = "dump-tag";
    public static final String DUMP_TYPE_OK = "ok";
    public static final String DUMP_TYPE_REMOVE_OK = "remove-ok";
    public static final String DUMP_TYPE_ERROR = "error";
    public static final String PULL_EVENT = "pull";
    public static final String PULL_EVENT_BETA = "pull-beta";
    public static final String PULL_EVENT_BATCH = "pull-batch";
    public static final String PULL_EVENT_TAG = "pull-tag";
    public static final String PULL_TYPE_OK = "ok";
    public static final String PULL_TYPE_NOTFOUND = "not-found";
    public static final String PULL_TYPE_CONFLICT = "conflict";
    public static final String PULL_TYPE_ERROR = "error";

    public static void logPersistenceEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String event, String type, String content) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        String md5 = content == null ? null : MD5Utils.md5Hex((String)content, (String)Constants.PERSIST_ENCODE);
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, event, type, -1, md5});
    }

    public static void logNotifyEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String event, String type, long delayed, String targetIp) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (delayed < 0L) {
            delayed = 0L;
        }
        MetricsMonitor.getNotifyRtTimer().record(delayed, TimeUnit.MILLISECONDS);
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, event, type, delayed, targetIp});
    }

    public static void logDumpEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, long delayed, long length) {
        ConfigTraceService.logDumpEventInner(dataId, group, tenant, requestIpAppName, ts, handleIp, DUMP_EVENT, type, delayed, length);
    }

    public static void logDumpBetaEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, long delayed, long length) {
        ConfigTraceService.logDumpEventInner(dataId, group, tenant, requestIpAppName, ts, handleIp, DUMP_EVENT_BETA, type, delayed, length);
    }

    public static void logDumpBatchEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type, long delayed, long length) {
        ConfigTraceService.logDumpEventInner(dataId, group, tenant, requestIpAppName, ts, handleIp, DUMP_EVENT_BATCH, type, delayed, length);
    }

    public static void logDumpTagEvent(String dataId, String group, String tenant, String tag, String requestIpAppName, long ts, String handleIp, String type, long delayed, long length) {
        ConfigTraceService.logDumpEventInner(dataId, group, tenant, requestIpAppName, ts, handleIp, "dump-tag-" + tag, type, delayed, length);
    }

    private static void logDumpEventInner(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String event, String type, long delayed, long length) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (delayed < 0L) {
            delayed = 0L;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, event, type, delayed, length});
    }

    public static void logDumpAllEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String handleIp, String type) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, handleIp, "dump-all", type, -1});
    }

    public static void logPullEvent(String dataId, String group, String tenant, String requestIpAppName, long ts, String event, String type, long delayed, String clientIp, boolean isNotify, String model) {
        if (!LogUtil.TRACE_LOG.isInfoEnabled()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = null;
        }
        if (isNotify && delayed < 0L) {
            delayed = 0L;
        }
        LogUtil.TRACE_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{InetUtils.getSelfIP(), dataId, group, tenant, requestIpAppName, ts, event, type, delayed, clientIp, isNotify, model});
    }
}

