/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers.v2;

import com.alibaba.nacos.api.model.v2.Result;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.naming.core.CatalogServiceV2Impl;
import com.alibaba.nacos.naming.paramcheck.NamingDefaultHttpParamExtractor;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/ns/catalog"})
@ExtractorManager.Extractor(httpExtractor=NamingDefaultHttpParamExtractor.class)
public class CatalogControllerV2 {
    @Autowired
    private CatalogServiceV2Impl catalogServiceV2;

    @Secured(action=ActionTypes.READ)
    @RequestMapping(value={"/instances"})
    public Result<ObjectNode> instanceList(@RequestParam(defaultValue="public") String namespaceId, @RequestParam String serviceName, @RequestParam(required=false) Boolean healthyOnly, @RequestParam(required=false) Boolean enabledOnly, @RequestParam(name="pageNo") int page, @RequestParam int pageSize) {
        String serviceNameWithoutGroup = NamingUtils.getServiceName((String)serviceName);
        String groupName = NamingUtils.getGroupName((String)serviceName);
        List<? extends Instance> instances = this.catalogServiceV2.listAllInstances(namespaceId, groupName, serviceNameWithoutGroup);
        int start = (page - 1) * pageSize;
        if (start < 0) {
            start = 0;
        }
        int end = start + pageSize;
        if (start > instances.size()) {
            start = instances.size();
        }
        if (end > instances.size()) {
            end = instances.size();
        }
        Stream<Object> stream = instances.stream();
        if (healthyOnly != null) {
            stream = stream.filter(instance -> instance.isHealthy() == healthyOnly.booleanValue());
        }
        if (enabledOnly != null) {
            stream = stream.filter(i -> i.isEnabled() == enabledOnly.booleanValue());
        }
        List ins = stream.collect(Collectors.toList());
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        if (ins.size() > start) {
            result.replace("instances", JacksonUtils.transferToJsonNode(ins.subList(start, end)));
        }
        result.put("count", ins.size());
        return Result.success((Object)result);
    }
}

