/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.paramcheck;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class NamingDefaultHttpParamExtractor
extends AbstractHttpParamExtractor {
    public List<ParamInfo> extractParam(HttpServletRequest request) throws NacosException {
        ParamInfo paramInfo = new ParamInfo();
        paramInfo.setIp(this.getAliasIp(request));
        paramInfo.setPort(this.getAliasPort(request));
        paramInfo.setNamespaceId(this.getAliasNamespaceId(request));
        paramInfo.setCluster(this.getAliasClusterName(request));
        String serviceName = this.getAliasServiceName(request);
        String groupName = this.getAliasGroupName(request);
        String groupServiceName = serviceName;
        if (StringUtils.isNotBlank((String)groupServiceName) && groupServiceName.contains("@@")) {
            String[] splits = groupServiceName.split("@@", 2);
            groupName = splits[0];
            serviceName = splits[1];
        }
        paramInfo.setServiceName(serviceName);
        paramInfo.setGroup(groupName);
        paramInfo.setMetadata(UtilsAndCommons.parseMetadata(request.getParameter("metadata")));
        ArrayList<ParamInfo> paramInfos = new ArrayList<ParamInfo>();
        paramInfos.add(paramInfo);
        return paramInfos;
    }

    private String getAliasNamespaceId(HttpServletRequest request) {
        String namespaceid = request.getParameter("namespaceId");
        return namespaceid;
    }

    private String getAliasIp(HttpServletRequest request) {
        String ip = request.getParameter("ip");
        return ip;
    }

    private String getAliasPort(HttpServletRequest request) {
        String port = request.getParameter("port");
        if (StringUtils.isBlank((CharSequence)port)) {
            port = request.getParameter("checkPort");
        }
        return port;
    }

    private String getAliasServiceName(HttpServletRequest request) {
        String serviceName = request.getParameter("serviceName");
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            serviceName = request.getParameter("serviceNameParam");
        }
        return serviceName;
    }

    private String getAliasGroupName(HttpServletRequest request) {
        String groupName = request.getParameter("groupName");
        if (StringUtils.isBlank((CharSequence)groupName)) {
            groupName = request.getParameter("groupNameParam");
        }
        return groupName;
    }

    private String getAliasClusterName(HttpServletRequest request) {
        String clusterName = request.getParameter("clusterName");
        if (StringUtils.isBlank((CharSequence)clusterName)) {
            clusterName = request.getParameter("cluster");
        } else if (StringUtils.isBlank((CharSequence)clusterName)) {
            clusterName = request.getParameter("clusters");
        }
        return clusterName;
    }
}

