/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.remote.rpc.handler;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.remote.request.PersistentInstanceRequest;
import com.alibaba.nacos.api.naming.remote.response.InstanceResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.trace.DeregisterInstanceReason;
import com.alibaba.nacos.common.trace.event.naming.DeregisterInstanceTraceEvent;
import com.alibaba.nacos.common.trace.event.naming.RegisterInstanceTraceEvent;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.PersistentInstanceRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.service.impl.PersistentClientOperationServiceImpl;
import com.alibaba.nacos.naming.utils.InstanceUtil;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import org.springframework.stereotype.Component;

@Component
public class PersistentInstanceRequestHandler
extends RequestHandler<PersistentInstanceRequest, InstanceResponse> {
    private final PersistentClientOperationServiceImpl clientOperationService;

    public PersistentInstanceRequestHandler(PersistentClientOperationServiceImpl clientOperationService) {
        this.clientOperationService = clientOperationService;
    }

    @TpsControl(pointName="RemoteNamingInstanceRegisterDeregister", name="RemoteNamingInstanceRegisterDeregister")
    @Secured(action=ActionTypes.WRITE)
    @ExtractorManager.Extractor(rpcExtractor=PersistentInstanceRequestParamExtractor.class)
    public InstanceResponse handle(PersistentInstanceRequest request, RequestMeta meta) throws NacosException {
        Service service = Service.newService(request.getNamespace(), request.getGroupName(), request.getServiceName(), false);
        InstanceUtil.setInstanceIdIfEmpty(request.getInstance(), service.getGroupedServiceName());
        switch (request.getType()) {
            case "registerInstance": {
                return this.registerInstance(service, request, meta);
            }
            case "deregisterInstance": {
                return this.deregisterInstance(service, request, meta);
            }
        }
        throw new NacosException(400, String.format("Unsupported request type %s", request.getType()));
    }

    private InstanceResponse registerInstance(Service service, PersistentInstanceRequest request, RequestMeta meta) {
        Instance instance = request.getInstance();
        String clientId = IpPortBasedClient.getClientId(instance.toInetAddr(), false);
        this.clientOperationService.registerInstance(service, instance, clientId);
        NotifyCenter.publishEvent((Event)new RegisterInstanceTraceEvent(System.currentTimeMillis(), meta.getClientIp(), true, service.getNamespace(), service.getGroup(), service.getName(), instance.getIp(), instance.getPort()));
        return new InstanceResponse("registerInstance");
    }

    private InstanceResponse deregisterInstance(Service service, PersistentInstanceRequest request, RequestMeta meta) {
        Instance instance = request.getInstance();
        String clientId = IpPortBasedClient.getClientId(instance.toInetAddr(), false);
        this.clientOperationService.deregisterInstance(service, instance, clientId);
        NotifyCenter.publishEvent((Event)new DeregisterInstanceTraceEvent(System.currentTimeMillis(), meta.getClientIp(), true, DeregisterInstanceReason.REQUEST, service.getNamespace(), service.getGroup(), service.getName(), instance.getIp(), instance.getPort()));
        return new InstanceResponse("deregisterInstance");
    }
}

