/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Server;
import com.tongweb.container.core.AprStatus;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.jni.Library;
import com.tongweb.web.jni.LibraryNotFoundError;
import com.tongweb.web.jni.SSL;
import com.tongweb.web.util.ExceptionUtils;
import com.tongweb.web.util.res.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AprLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(AprLifecycleListener.class);
    private static final List<String> initInfoLogMessages = new ArrayList<String>(3);
    protected static final StringManager sm = StringManager.getManager(AprLifecycleListener.class);
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 2;
    protected static final int TCN_REQUIRED_PATCH = 34;
    protected static final int TCN_RECOMMENDED_MAJOR = 2;
    protected static final int TCN_RECOMMENDED_MINOR = 0;
    protected static final int TCN_RECOMMENDED_PV = 1;
    private static int tcnMajor = 0;
    private static int tcnMinor = 0;
    private static int tcnPatch = 0;
    private static int tcnVersion = 0;
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    protected static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAprAvailable() {
        if (AprStatus.isInstanceCreated()) {
            Object object = lock;
            synchronized (object) {
                AprLifecycleListener.init();
            }
        }
        return AprStatus.isAprAvailable();
    }

    public AprLifecycleListener() {
        AprStatus.setInstanceCreated(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!(event.getLifecycle() instanceof Server)) {
                    log.warn(sm.getString("listener.notServer", event.getLifecycle().getClass().getSimpleName()));
                }
                AprLifecycleListener.init();
                for (String msg : initInfoLogMessages) {
                    log.info(msg);
                }
                initInfoLogMessages.clear();
                if (AprStatus.isAprAvailable()) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        t = ExceptionUtils.unwrapInvocationTargetException(t);
                        ExceptionUtils.handleThrowable(t);
                        log.error(sm.getString("aprListener.sslInit"), t);
                    }
                }
                if (null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode) && !this.isFIPSModeActive()) {
                    String errorMessage = sm.getString("aprListener.initializeFIPSFailed");
                    Error e = new Error(errorMessage);
                    log.fatal(errorMessage, e);
                    throw e;
                }
            }
        }
        if ("after_destroy".equals(event.getType())) {
            Object object = lock;
            synchronized (object) {
                if (!AprStatus.isAprAvailable()) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    t = ExceptionUtils.unwrapInvocationTargetException(t);
                    ExceptionUtils.handleThrowable(t);
                    log.info(sm.getString("aprListener.aprDestroy"));
                }
            }
        }
    }

    private static void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("com.tongweb.web.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
        AprStatus.setAprAvailable(false);
        AprStatus.setAprInitialized(false);
        sslInitialized = false;
        fipsModeActive = false;
    }

    private static void init() {
        int rqver = 1234;
        int rcver = 2001;
        if (AprStatus.isAprInitialized()) {
            return;
        }
        AprStatus.setAprInitialized(true);
        try {
            Library.initialize(null);
            tcnMajor = Library.TCN_MAJOR_VERSION;
            tcnMinor = Library.TCN_MINOR_VERSION;
            tcnPatch = Library.TCN_PATCH_VERSION;
            tcnVersion = tcnMajor * 1000 + tcnMinor * 100 + tcnPatch;
        }
        catch (LibraryNotFoundError lnfe) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("aprListener.aprInitDebug", lnfe.getLibraryNames(), System.getProperty("java.library.path"), lnfe.getMessage()), lnfe);
            }
            initInfoLogMessages.add(sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
            return;
        }
        catch (Throwable t) {
            t = ExceptionUtils.unwrapInvocationTargetException(t);
            ExceptionUtils.handleThrowable(t);
            log.warn(sm.getString("aprListener.aprInitError", t.getMessage()), t);
            return;
        }
        if (tcnMajor > 1 && "off".equalsIgnoreCase(SSLEngine)) {
            log.error(sm.getString("aprListener.sslRequired", SSLEngine, Library.versionString()));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                t = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(t);
            }
            return;
        }
        if (tcnVersion < rqver) {
            log.error(sm.getString("aprListener.tcnInvalid", Library.versionString(), "1.2.34"));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                t = ExceptionUtils.unwrapInvocationTargetException(t);
                ExceptionUtils.handleThrowable(t);
            }
            return;
        }
        if (tcnVersion < rcver) {
            initInfoLogMessages.add(sm.getString("aprListener.tcnVersion", Library.versionString(), "2.0.1"));
        }
        initInfoLogMessages.add(sm.getString("aprListener.tcnValid", Library.versionString(), Library.aprVersionString()));
        AprStatus.setAprAvailable(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void initializeSSL() throws Exception {
        boolean usingProviders;
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        sslInitialized = true;
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("com.tongweb.web.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        boolean bl = usingProviders = tcnMajor > 1 || tcnVersion > 1233 && ((long)SSL.version() & 0xF0000000L) > 0x20000000L;
        if (usingProviders || null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
            boolean enterFipsMode;
            int fipsModeState;
            block25: {
                fipsModeActive = false;
                fipsModeState = SSL.fipsModeGet();
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("aprListener.currentFIPSMode", fipsModeState));
                }
                if (null == FIPSMode || "off".equalsIgnoreCase(FIPSMode)) {
                    if (fipsModeState == 1) {
                        fipsModeActive = true;
                    }
                    enterFipsMode = false;
                } else if ("on".equalsIgnoreCase(FIPSMode)) {
                    if (fipsModeState == 1) {
                        if (!usingProviders) {
                            log.info(sm.getString("aprListener.skipFIPSInitialization"));
                        }
                        fipsModeActive = true;
                        enterFipsMode = false;
                    } else {
                        if (usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", FIPSMode));
                        }
                        enterFipsMode = true;
                    }
                } else {
                    if ("require".equalsIgnoreCase(FIPSMode)) {
                        if (fipsModeState == 1) {
                            fipsModeActive = true;
                            enterFipsMode = false;
                            break block25;
                        } else {
                            if (usingProviders) {
                                throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", FIPSMode));
                            }
                            throw new IllegalStateException(sm.getString("aprListener.requireNotInFIPSMode"));
                        }
                    }
                    if (!"enter".equalsIgnoreCase(FIPSMode)) {
                        throw new IllegalArgumentException(sm.getString("aprListener.wrongFIPSMode", FIPSMode));
                    }
                    if (fipsModeState == 0) {
                        if (usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.FIPSProviderNotDefault", FIPSMode));
                        }
                        enterFipsMode = true;
                    } else {
                        if (!usingProviders) {
                            throw new IllegalStateException(sm.getString("aprListener.enterAlreadyInFIPSMode", fipsModeState));
                        }
                        fipsModeActive = true;
                        enterFipsMode = false;
                    }
                }
            }
            if (enterFipsMode) {
                log.info(sm.getString("aprListener.initializingFIPS"));
                fipsModeState = SSL.fipsModeSet(1);
                if (fipsModeState != 1) {
                    String message = sm.getString("aprListener.initializeFIPSFailed");
                    log.error(message);
                    throw new IllegalStateException(message);
                }
                fipsModeActive = true;
                log.info(sm.getString("aprListener.initializeFIPSSuccess"));
            }
            if (usingProviders && fipsModeActive) {
                log.info(sm.getString("aprListener.usingFIPSProvider"));
            }
        }
        log.info(sm.getString("aprListener.initializedOpenSSL", SSL.versionString()));
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine2) {
        if (!SSLEngine2.equals(SSLEngine)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLEngine"));
            }
            SSLEngine = SSLEngine2;
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(AprLifecycleListener.SSLRandomSeed)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForSSLRandomSeed"));
            }
            AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public String getFIPSMode() {
        return FIPSMode;
    }

    public void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(AprLifecycleListener.FIPSMode)) {
            if (sslInitialized) {
                throw new IllegalStateException(sm.getString("aprListener.tooLateForFIPSMode"));
            }
            AprLifecycleListener.FIPSMode = FIPSMode;
        }
    }

    public boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    public void setUseOpenSSL(boolean useOpenSSL) {
        if (useOpenSSL != AprStatus.getUseOpenSSL()) {
            AprStatus.setUseOpenSSL(useOpenSSL);
        }
    }

    public static boolean getUseOpenSSL() {
        return AprStatus.getUseOpenSSL();
    }

    public static boolean isInstanceCreated() {
        return AprStatus.isInstanceCreated();
    }
}

