/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.security;

import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.res.StringManager;
import java.lang.reflect.Field;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class PrivilegedSetAccessControlContext
implements PrivilegedAction<Void> {
    private static final Log log = LogFactory.getLog(PrivilegedSetAccessControlContext.class);
    private static final StringManager sm = StringManager.getManager(PrivilegedSetAccessControlContext.class);
    private static final AccessControlContext acc = AccessController.getContext();
    private static final Field field;
    private final Thread t;

    public PrivilegedSetAccessControlContext(Thread t) {
        this.t = t;
    }

    @Override
    public Void run() {
        try {
            if (field != null) {
                field.set(this.t, acc);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.warn(sm.getString("privilegedSetAccessControlContext.setFailed"), e);
        }
        return null;
    }

    static {
        Field f = null;
        try {
            f = Thread.class.getDeclaredField("inheritedAccessControlContext");
            f.trySetAccessible();
        }
        catch (NoSuchFieldException | SecurityException e) {
            log.warn(sm.getString("privilegedSetAccessControlContext.lookupFailed"), e);
        }
        field = f;
    }
}

