/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.authenticate;

import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import com.alibaba.nacos.plugin.auth.impl.authenticate.DefaultAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.authenticate.IAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.authenticate.LdapAuthenticationManager;
import com.alibaba.nacos.plugin.auth.impl.constant.AuthSystemTypes;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUser;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;

public class AuthenticationManagerDelegator
implements IAuthenticationManager {
    private ObjectProvider<DefaultAuthenticationManager> defaultAuthenticationManager;
    private ObjectProvider<LdapAuthenticationManager> ldapAuthenticationManager;
    private AuthConfigs authConfigs;

    public AuthenticationManagerDelegator(ObjectProvider<DefaultAuthenticationManager> nacosAuthManager, ObjectProvider<LdapAuthenticationManager> ldapAuthenticationProvider, AuthConfigs authConfigs) {
        this.defaultAuthenticationManager = nacosAuthManager;
        this.ldapAuthenticationManager = ldapAuthenticationProvider;
        this.authConfigs = authConfigs;
    }

    @Override
    public NacosUser authenticate(String username, String password) throws AccessException {
        return this.getManager().authenticate(username, password);
    }

    @Override
    public NacosUser authenticate(String jwtToken) throws AccessException {
        return this.getManager().authenticate(jwtToken);
    }

    @Override
    public NacosUser authenticate(HttpServletRequest httpServletRequest) throws AccessException {
        return this.getManager().authenticate(httpServletRequest);
    }

    @Override
    public void authorize(Permission permission, NacosUser nacosUser) throws AccessException {
        this.getManager().authorize(permission, nacosUser);
    }

    @Override
    public boolean hasGlobalAdminRole(String username) {
        return this.getManager().hasGlobalAdminRole(username);
    }

    @Override
    public boolean hasGlobalAdminRole(NacosUser nacosUser) {
        return this.getManager().hasGlobalAdminRole(nacosUser);
    }

    private IAuthenticationManager getManager() {
        if (AuthSystemTypes.LDAP.name().equalsIgnoreCase(this.authConfigs.getNacosAuthSystemType())) {
            return (IAuthenticationManager)this.ldapAuthenticationManager.getIfAvailable();
        }
        return (IAuthenticationManager)this.defaultAuthenticationManager.getIfAvailable();
    }
}

