/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor.topn;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.concurrent.TimeUnit;

public class TopNConfig
extends AbstractDynamicConfig {
    private static final String TOP_N = "topN";
    private static final TopNConfig INSTANCE = new TopNConfig();
    private static final String TOP_N_PREFIX = "nacos.core.monitor.topn.";
    private static final String ENABLED_KEY = "nacos.core.monitor.topn.enabled";
    private static final String COUNT_KEY = "nacos.core.monitor.topn.count";
    private static final String INTERNAL_MS_KEY = "nacos.core.monitor.topn.internalMs";
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_COUNT = 10;
    private static final long DEFAULT_INTERNAL_MS = TimeUnit.SECONDS.toMillis(30L);
    private boolean enabled;
    private int topNCount;
    private long internalMs;

    private TopNConfig() {
        super(TOP_N);
    }

    @Override
    protected void getConfigFromEnv() {
        this.enabled = (Boolean)EnvUtil.getProperty((String)ENABLED_KEY, Boolean.class, (Object)true);
        this.topNCount = (Integer)EnvUtil.getProperty((String)COUNT_KEY, Integer.class, (Object)10);
        this.internalMs = (Long)EnvUtil.getProperty((String)INTERNAL_MS_KEY, Long.class, (Object)DEFAULT_INTERNAL_MS);
    }

    @Override
    protected String printConfig() {
        return this.toString();
    }

    public String toString() {
        return "TopNConfig{enabled=" + this.enabled + ", topNCount=" + this.topNCount + ", internalMs=" + this.internalMs + '}';
    }

    public static TopNConfig getInstance() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTopNCount() {
        return this.topNCount;
    }

    public long getInternalMs() {
        return this.internalMs;
    }
}

