/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.common.utils.ConnLabelsUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ConnectionMeta {
    String connectType;
    String clientIp;
    String remoteIp;
    int remotePort;
    int localPort;
    String version;
    String connectionId;
    Date createTime;
    long lastActiveTime;
    String appName;
    String tenant;
    long firstPushQueueBlockTime = 0L;
    long lastPushQueueBlockTime = 0L;
    protected Map<String, String> labels = new HashMap<String, String>();

    public String getLabel(String labelKey) {
        return this.labels.get(labelKey);
    }

    public String getTag() {
        return this.labels.get("Vipserver-Tag");
    }

    public ConnectionMeta(String connectionId, String clientIp, String remoteIp, int remotePort, int localPort, String connectType, String version, String appName, Map<String, String> labels) {
        this.connectionId = connectionId;
        this.clientIp = clientIp;
        this.connectType = connectType;
        this.version = version;
        this.appName = appName;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
        this.localPort = localPort;
        this.createTime = new Date();
        this.lastActiveTime = System.currentTimeMillis();
        this.labels.putAll(labels);
    }

    public boolean isSdkSource() {
        String source = this.labels.get("source");
        return "sdk".equalsIgnoreCase(source);
    }

    public boolean isClusterSource() {
        String source = this.labels.get("source");
        return "cluster".equalsIgnoreCase(source);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAppLabels() {
        HashMap<String, String> labelsMap = new HashMap<String, String>(8){
            {
                this.put("AppName", ConnectionMeta.this.labels.get("AppName"));
                this.put("ClientVersion", ConnectionMeta.this.version);
            }
        };
        return ConnLabelsUtils.mergeMapByOrder((Map)labelsMap, this.labels.entrySet().stream().filter(Objects::nonNull).filter(e -> ((String)e.getKey()).startsWith("app_") && ((String)e.getKey()).length() > "app_".length() && StringUtils.isNotBlank((String)((String)e.getValue()))).collect(Collectors.toMap(k -> ((String)k.getKey()).substring("app_".length()), Map.Entry::getValue)));
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public String getConnectType() {
        return this.connectType;
    }

    public void setConnectType(String connectType) {
        this.connectType = connectType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void recordPushQueueBlockTimes() {
        if (this.firstPushQueueBlockTime == 0L) {
            this.firstPushQueueBlockTime = System.currentTimeMillis();
        } else {
            this.lastPushQueueBlockTime = System.currentTimeMillis();
        }
    }

    public void clearPushQueueBlockTimes() {
        this.firstPushQueueBlockTime = 0L;
        this.lastPushQueueBlockTime = 0L;
    }

    public boolean pushQueueBlockTimesLastOver(long timeMillsSeconds) {
        return this.lastPushQueueBlockTime - this.firstPushQueueBlockTime > timeMillsSeconds;
    }

    public String toString() {
        return "ConnectionMeta{connectType='" + this.connectType + '\'' + ", clientIp='" + this.clientIp + '\'' + ", remoteIp='" + this.remoteIp + '\'' + ", remotePort=" + this.remotePort + ", localPort=" + this.localPort + ", version='" + this.version + '\'' + ", connectionId='" + this.connectionId + '\'' + ", createTime=" + this.createTime + ", lastActiveTime=" + this.lastActiveTime + ", appName='" + this.appName + '\'' + ", tenant='" + this.tenant + '\'' + ", labels=" + this.labels + '}';
    }
}

