/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc.negotiator.tls;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.packagescan.resource.DefaultResourceLoader;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.packagescan.resource.ResourceLoader;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.TlsTypeResolve;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfig;
import com.alibaba.nacos.core.utils.Loggers;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.net.ssl.SSLException;

public class DefaultTlsContextBuilder {
    private static final ResourceLoader RESOURCE_LOADER = new DefaultResourceLoader();

    static SslContext getSslContext(RpcServerTlsConfig rpcServerTlsConfig) {
        try {
            if (StringUtils.isBlank((CharSequence)rpcServerTlsConfig.getCertChainFile()) || StringUtils.isBlank((CharSequence)rpcServerTlsConfig.getCertPrivateKey())) {
                throw new IllegalArgumentException("Server certChainFile or certPrivateKey must be not null");
            }
            InputStream certificateChainFile = DefaultTlsContextBuilder.getInputStream(rpcServerTlsConfig.getCertChainFile(), "certChainFile");
            InputStream privateKeyFile = DefaultTlsContextBuilder.getInputStream(rpcServerTlsConfig.getCertPrivateKey(), "certPrivateKey");
            SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((InputStream)certificateChainFile, (InputStream)privateKeyFile, (String)rpcServerTlsConfig.getCertPrivateKeyPassword());
            if (StringUtils.isNotBlank((String)rpcServerTlsConfig.getProtocols())) {
                sslClientContextBuilder.protocols(rpcServerTlsConfig.getProtocols().split(","));
            }
            if (StringUtils.isNotBlank((String)rpcServerTlsConfig.getCiphers())) {
                sslClientContextBuilder.ciphers(Arrays.asList(rpcServerTlsConfig.getCiphers().split(",")));
            }
            if (rpcServerTlsConfig.getMutualAuthEnable().booleanValue()) {
                if (rpcServerTlsConfig.getTrustAll().booleanValue()) {
                    sslClientContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else {
                    if (StringUtils.isBlank((CharSequence)rpcServerTlsConfig.getTrustCollectionCertFile())) {
                        throw new IllegalArgumentException("enable mutual auth,trustCollectionCertFile must be not null");
                    }
                    InputStream clientCert = DefaultTlsContextBuilder.getInputStream(rpcServerTlsConfig.getTrustCollectionCertFile(), "trustCollectionCertFile");
                    sslClientContextBuilder.trustManager(clientCert);
                }
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
            SslContextBuilder configure = GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)TlsTypeResolve.getSslProvider((String)rpcServerTlsConfig.getSslProvider()));
            return configure.build();
        }
        catch (SSLException e) {
            Loggers.REMOTE.info("Nacos Rpc server reload ssl context fail tls config:{}", (Object)JacksonUtils.toJson((Object)((Object)rpcServerTlsConfig)));
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    private static InputStream getInputStream(String path, String config) {
        try {
            Resource resource = RESOURCE_LOADER.getResource(path);
            return resource.getInputStream();
        }
        catch (IOException e) {
            throw new NacosRuntimeException(500, config + " load fail", (Throwable)e);
        }
    }
}

