/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.tls;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.tls.RpcServerSslContextRefresher;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfig;
import com.alibaba.nacos.core.utils.Loggers;
import java.util.Collection;

public class RpcServerSslContextRefresherHolder {
    private static RpcServerSslContextRefresher instance;
    private static volatile boolean init;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcServerSslContextRefresher getInstance() {
        if (init) {
            return instance;
        }
        Class<RpcServerSslContextRefresherHolder> clazz = RpcServerSslContextRefresherHolder.class;
        synchronized (RpcServerSslContextRefresherHolder.class) {
            if (init) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            RpcServerTlsConfig rpcServerTlsConfig = RpcServerTlsConfig.getInstance();
            String sslContextRefresher = rpcServerTlsConfig.getSslContextRefresher();
            if (StringUtils.isNotBlank((String)sslContextRefresher)) {
                Collection load = NacosServiceLoader.load(RpcServerSslContextRefresher.class);
                for (RpcServerSslContextRefresher contextRefresher : load) {
                    if (!sslContextRefresher.equals(contextRefresher.getName())) continue;
                    instance = contextRefresher;
                    Loggers.REMOTE.info("RpcServerSslContextRefresher of Name {} Founded->{}", (Object)sslContextRefresher, (Object)contextRefresher.getClass().getSimpleName());
                    break;
                }
                if (instance == null) {
                    Loggers.REMOTE.info("RpcServerSslContextRefresher of Name {} not found", (Object)sslContextRefresher);
                }
            } else {
                Loggers.REMOTE.info("No RpcServerSslContextRefresher specified,Ssl Context auto refresh not supported.");
            }
            Loggers.REMOTE.info("RpcServerSslContextRefresher init end");
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static {
        init = false;
    }
}

