/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.api;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.mcp.EmptyMcpGenerator;
import com.alibaba.nacos.istio.mcp.ServiceEntryMcpGenerator;
import com.alibaba.nacos.istio.xds.EmptyXdsGenerator;
import com.alibaba.nacos.istio.xds.ServiceEntryXdsGenerator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ApiGeneratorFactory {
    private final Map<String, ApiGenerator<?>> apiGeneratorMap = new HashMap(2);

    public ApiGeneratorFactory() {
        this.apiGeneratorMap.put("networking.istio.io/v1alpha3/ServiceEntry", ServiceEntryXdsGenerator.getInstance());
        this.apiGeneratorMap.put("istio/networking/v1alpha3/serviceentries", ServiceEntryMcpGenerator.getInstance());
    }

    public ApiGenerator<?> getApiGenerator(String typeUrl) {
        EmptyMcpGenerator apiGenerator = this.apiGeneratorMap.get(typeUrl);
        return apiGenerator != null ? apiGenerator : (typeUrl.startsWith("istio/") ? EmptyMcpGenerator.getInstance() : EmptyXdsGenerator.getInstance());
    }
}

