# 概要设计说明书

## （一）引言

### 1. 编写目的
本文档旨在为`jyh-zjk`专家库系统的开发团队和相关人员提供概要设计指导，明确系统架构、功能模块划分、接口设计、数据结构设计等内容。目标读者包括项目经理、开发人员、测试人员以及后续维护人员。

### 2. 项目背景
- **委托单位**：某政府部门或企事业单位。
- **开发单位**：由阿里云技术团队基于`ruoyi-cloud-plus`框架进行开发。
- **主管部门**：负责专家库管理的相关部门。
- **与其他系统的关系**：
    - 统一用户中心：实现单点登录（SSO）。
    - 第三方中间件集成：如`Kingbase`数据库、`Redis`缓存、`MinIO`存储等。
    - 流程引擎：使用`Activity`支持复杂审批流程。
    - 监控与运维：通过`Sentinel`、`Prometheus`进行系统监控。

### 3. 定义
- **租户**：多租户系统中的逻辑隔离单元，每个租户拥有独立的数据空间。
- **专家库**：包含专家信息、资质审核、评审记录等数据的管理系统。
- **微服务**：基于Spring Cloud Alibaba构建的服务化架构。

---

## （二）任务概述

### 1. 目标
构建一个高效、安全、可扩展的专家库系统，支持以下核心业务流程：
1. **专家申请**：用户录入系统并提交专家申请。
2. **专家落库**：管理员审核专家资质后入库。
3. **项目维护**：设置评审项目及规则。
4. **专家抽取**：根据规则自动抽取专家参与评审。
5. **专家互评**：评审结束后专家间相互打分。
6. **积分录入**：根据评审表现计算专家积分。
7. **统计分析**：生成请假率、评审质量等可视化报表。

### 2. 运行环境
- **操作系统**：Linux（Kubernetes集群）。
- **JDK版本**：Java 17或更高版本。
- **容器化工具**：Docker + Kubernetes。
- **中间件**：
    - 数据库：`Kingbase`。
    - 缓存：`Redis`。
    - 存储：`MinIO`。
    - 注册配置中心：[Nacos](file://D:\jyh-zjk\ruoyi-visual\ruoyi-nacos\src\main\java\com\alibaba\nacos\Nacos.java#L37-L55)。
    - 全局事务：`Seata`。
    - 监控：`Sentinel`、`Prometheus`。

### 3. 需求概述
- **功能需求**：
    - 支持专家信息的增删改查。
    - 提供请假、审批、积分计算等功能。
    - 实现多租户逻辑隔离。
    - 提供丰富的统计分析功能。
- **非功能需求**：
    - 高并发支持。
    - 数据加密存储。
    - 系统稳定性保障（限流、熔断、分布式事务）。

### 4. 条件与限制
- **性能要求**：支持高并发访问，响应时间不超过200ms。
- **安全性要求**：
    - 敏感字段（如身份证号）需加密存储。
    - 接口权限控制到按钮级别。
    - 关键操作需记录审计日志。
- **部署限制**：必须在Kubernetes集群中运行。

---

## （三）总体设计

### 1. 处理流程
参见核心业务流程规范：
```markdown
1. 统一登录：通过用户中心单点登录。
2. 专家申请：用户录入系统并提交申请。
3. 资质审核：管理员审核专家资质。
4. 专家库维护：管理专家信息和状态。
5. 项目配置：设置评审项目和规则。
6. 专家抽取：根据规则自动抽取专家。
7. 评审执行：专家参与项目评审。
8. 专家互评：评审结束后专家间相互打分。
9. 积分计算：自动计算专家积分。
10. 统计分析：生成请假率、评审质量等可视化报表。
```


### 2. 总体结构和模块外部设计
系统采用微服务架构，划分为以下核心模块：
1. **认证服务**：`ruoyi-auth`（JWT鉴权）。
2. **专家服务**：`zjk-api`（专家CRUD操作）。
3. **评审服务**：`zjk-review`（抽取算法实现）。
4. **积分服务**：`zjk-point`（规则引擎处理积分计算）。
5. **监控服务**：`ruoyi-monitor`（集成Prometheus实现监控）。

### 3. 功能分配
| 功能模块       | 对应程序结构                     |
|----------------|----------------------------------|
| 用户登录       | `ruoyi-auth`                    |
| 专家管理       | `zjk-api`                       |
| 项目评审       | `zjk-review`                    |
| 积分计算       | `zjk-point`                     |
| 系统监控       | `ruoyi-monitor`                 |

---

## （四）接口设计

### 1. 外部接口
- **用户界面**：基于Vue3 + TypeScript + ElementPlus开发的前端页面。
- **软件接口**：
    - RESTful API：提供专家管理、项目评审等功能。
    - OpenFeign：服务间调用。
- **硬件接口**：无。

### 2. 内部接口
- **微服务间通信**：
    - 使用OpenFeign + Ribbon实现服务发现调用。
    - 示例接口：
        - `POST /leave/add`：新增请假记录。
        - `GET /point/queryPointList`：查询积分列表。

---

## （五）数据结构设计

### 1. 逻辑结构设计
核心实体关系包括：
- 专家与请假记录（1:N）。
- 专家与评审记录（1:N）。
- 项目与评审记录（1:N）。
- 专家与积分记录（1:N）。

### 2. 物理结构设计
关键表设计：
- `zjk_expert`：专家主表。
- `zjk_point`：积分记录表。
- `zjk_leave`：请假记录表。
- `zjk_review_phase`：评审阶段表。

### 3. 数据结构与程序的关系
- 数据表通过MyBatis Plus映射为Java实体类。
- 示例映射：
  ```java
  @Data
  public class ZjkExpert {
      private Long expertId;
      private String expertName;
      private String contact;
      private Integer status;
  }
  ```


---

## （六）运行设计

### 1. 运行模块的组合
各微服务通过Docker镜像打包后，部署至Kubernetes集群中。

### 2. 运行控制
- 启动顺序：
    1. Nacos注册中心。
    2. 各微服务模块（`ruoyi-auth`、`zjk-api`等）。
- 停止顺序：反向停止。

### 3. 运行时间
- 系统全天候运行，支持7x24小时服务。

---

## （七）出错处理设计

### 1. 出错输出信息
- 接口返回错误码及详细描述，如：
  ```json
  {
      "code": 500,
      "message": "系统内部错误，请稍后重试"
  }
  ```


### 2. 出错处理对策
- 设置后备机制：如Redis缓存失效时，回退至数据库。
- 性能降级：高峰期限流。
- 恢复及再启动：通过Kubernetes自动重启失败的Pod。

---

## （八）安全保密设计
1. **数据加密**：身份证号使用SM4算法加密存储。
2. **权限控制**：采用RBAC模型并支持字段级权限。
3. **审计追踪**：所有状态变更需记录至`zjk_data_changes_logs`表。

---

## （九）维护设计
1. **维护模块**：提供日志管理、监控告警等功能。
2. **热更新**：通过Nacos实现配置热更新。
3. **问题诊断**：集成Arthas实现线上问题实时诊断。

--- 
场景
压测指标
预期目标
用户登录QPS
认证链路过载（IAuthStrategy）
> 500 QPS
批量用户删除
数据库锁竞争
事务成功率 > 99.9%
租户列表查询
Redis缓存击穿
响应时间 < 50ms