### 详细设计说明书

#### 1. 引言

##### 1.1 文档目的
本文档旨在为专家库系统提供详细的软件设计说明，涵盖功能模块、类设计、数据模型、接口设计、业务流程、非功能性需求等方面。目标读者包括开发人员、测试人员、运维人员以及项目经理。

##### 1.2 系统概述
专家库系统是一个基于 `RuoYi-Cloud-Plus` 框架的多租户管理系统，支持专家申请、入库、项目维护、评审抽取、互评、积分管理及统计分析等功能。系统采用微服务架构，使用 PostgreSQL 数据库，Redis 缓存，MinIO 存储，Activiti 流程引擎等技术栈。

##### 1.3 定义与术语
- **多租户**：指系统支持多个独立用户群体（租户）共享同一套系统实例。
- **专家申请**：用户提交成为专家的申请，需经过审核后入库。
- **请假规则**：定义专家请假时长、提前天数等限制条件。
- **积分管理**：根据专家参与评审的表现自动计算积分。

##### 1.4 参考资料
- 需求文档：[gs2.md](file://D:\jyh-zjk\doc\gs2.md)
- 架构设计：[application-common.yml](file://D:\jyh-zjk\config\nacos\application-common.yml)
- 技术规范：`ZjkLeaveController.java`

##### 1.5 设计约束
- 技术栈：Java 17+、Spring Boot 3.x、PostgreSQL、Redis、MinIO
- 性能要求：支持高并发访问，响应时间小于 500ms
- 安全要求：Sa-Token + JWT 实现无状态认证，敏感字段加密存储

---

#### 2. 总体设计回顾

##### 2.1 架构设计摘要
系统采用微服务架构，核心模块包括：
- 认证服务（`ruoyi-auth`）
- 专家服务（`zjk-api`）
- 评审服务（`zjk-review`）
- 积分服务（`zjk-point`）
- 监控服务（`ruoyi-monitor`）

各服务通过 OpenFeign + Ribbon 实现服务发现与调用。

##### 2.2 本模块在系统中的位置
[ZjkLeaveController](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\controller\ZjkLeaveController.java#L36-L208) 是专家服务的核心控制器之一，负责处理专家请假相关的请求，包括请假列表查询、请假审批、请假次数统计等功能。

---

#### 3. 模块/子系统详细设计

##### 3.1 功能模块划分

###### 模块1：请假管理
- **功能描述**：提供专家请假申请、审批、统计等功能。
- **输入/输出**：
    - 输入：请假申请表单（[ZjkLeaveBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveBo.java#L17-L68)）、请假规则配置（[ZjkLeaveRuleBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveRuleBo.java#L17-L43)）
    - 输出：请假记录列表（`TableDataInfo<ZjkLeaveVo>`）、请假统计数据（`StsNumVO`）
- **处理逻辑**：
  ```java
  @GetMapping("/pros")
  public TableDataInfo<ZjkEvaluateVO> getLeavePros() {
      return zjkLeaveService.getLeavePros();
  }
  ```

  上述代码实现了获取待参评项目的功能，返回值为分页数据结构。
- **接口定义**：
    - URL: `/leave/pros`
    - Method: GET
    - 示例：
      ```json
      {
        "code": 200,
        "msg": "success",
        "data": {
          "records": [...],
          "total": 100
        }
      }
      ```


###### 模块2：请假规则管理
- **功能描述**：定义和管理专家请假规则。
- **输入/输出**：
    - 输入：请假规则配置（[ZjkLeaveRuleBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveRuleBo.java#L17-L43)）
    - 输出：请假规则详情（[ZjkLeaveRuleVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkLeaveRuleVo.java#L22-L87)）
- **处理逻辑**：
  ```java
  @GetMapping("/getRule")
  public R<ZjkLeaveRuleVo> getLeavelRule() {
      return R.ok(zjkLeaveRuleService.selectRuleByTannet());
  }
  ```

  上述代码实现了查询当前租户的请假规则。

---

#### 4. 类/对象设计

##### 类图
```plantuml
@startuml
class ZjkLeaveController {
    +getLeavePros(): TableDataInfo<ZjkEvaluateVO>
    +getProsForAccept(): TableDataInfo<ZjkEvaluateVO>
    +leaveForPro(bo: ZjkEvaluateVO): R<Void>
}

class IZjkLeaveService {
    <<interface>>
    +getLeavePros(): TableDataInfo<ZjkEvaluateVO>
    +getProsForAccept(): TableDataInfo<ZjkEvaluateVO>
    +leaveForPro(bo: ZjkEvaluateVO): R<Void>
}

ZjkLeaveController --|> IZjkLeaveService : implements
@enduml
```


##### 关键类说明
- **ZjkLeaveController**：控制器层，负责接收 HTTP 请求并调用服务层方法。
- **IZjkLeaveService**：服务层接口，定义了请假相关的核心业务逻辑。

---

#### 5. 数据模型设计

##### 数据库表结构
```sql
CREATE TABLE "public"."zjk_leave" (
  "gid" varchar(32),
  "leave_resource" int4,
  "create_by" int8,
  "create_time" timestamp(6),
  "update_by" int8,
  "update_time" timestamp(6)
);
COMMENT ON COLUMN "public"."zjk_leave"."leave_resource" IS '0:自己请假；1:管理员替代请假';
```


##### 缓存设计
- Redis 键结构：`leave:rule:{tenantId}`
- 过期策略：5 分钟 TTL

---

#### 6. 接口设计

##### 外部接口
- 第三方短信服务：用于发送请假通知。

##### 内部接口
- 微服务间 API：`/leave/getRule` 查询请假规则。

##### 接口安全
- 认证方式：JWT Token
- 加密机制：API 响应使用 AES 加密头标识。

---

#### 7. 业务流程设计

##### 关键业务场景时序图
```plantuml
@startuml
actor 用户
participant ZjkLeaveController
participant IZjkLeaveService

用户 -> ZjkLeaveController: GET /leave/pros
ZjkLeaveController -> IZjkLeaveService: getLeavePros()
IZjkLeaveService --> ZjkLeaveController: 返回分页数据
ZjkLeaveController --> 用户: 返回结果
@enduml
```


---

#### 8. 非功能性设计

##### 性能设计
- 吞吐量目标：每秒处理 1000 次请求。
- 数据库分库分表策略：按 `tenant_id` 水平分表。

##### 安全设计
- 数据加密：身份证号使用 SM4 算法加密存储。
- 权限控制：RBAC 模型，字段级权限控制。

---

#### 9. 待解决问题与风险
- 技术难点：多数据源事务一致性。
- 备选方案：引入 Seata 解决分布式事务问题。

---

