# 专家库系统详细设计文档

## 3. 模块/子系统详细设计

### 3.1 功能模块划分
---
#### 模块1：`专家画像管理`
- **功能描述**: 提供专家的基本信息展示和知识图谱分析，包括基本信息、同院校/单位/专业专家等维度的数据。
- **输入/输出**:
    - 输入: 用户ID (`Long userId`)
    - 输出: 包含专家基本信息的 [ChartBaseVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ChartBaseVO.java#L18-L153) 和包含相关专家信息的 [ChartRelExpertVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ChartRelExpertVO.java#L14-L21)
- **处理逻辑**:
```java
// 获取专家基本信息
@GetMapping("/chartBase")
public R<ChartBaseVO> getChartBase(Long userId) {
    return zjkExpertChartService.getChartBase(userId);
}

// 获取与指定专家相关的其他专家信息
@GetMapping("/sameOther")
public R<ChartRelExpertVO> getSameOtherData(Long userId) {
    return zjkExpertChartService.getSameOtherData(userId);
}

// 获取所有专家简化信息列表
@GetMapping("/users")
public R<List<SimpleExpertDto>> getExperts() {
    return zjkExpertChartService.getExperts();
}
```


- **接口定义**:
    - API签名:
        - `GET /chart/chartBase?userId={userId}`
        - `GET /chart/sameOther?userId={userId}`
        - `GET /chart/users`
    - 消息格式: JSON
    - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "userId": 123,
    "name": "张三",
    "creditLevel": "A",
    "papersCount": 50,
    "awards": "国家级奖项"
  }
}
```


---

#### 模块2：`积分管理`
- **功能描述**: 管理专家的积分规则、奖励配置、积分记录查询及统计分析。支持积分规则定义、奖励设置、积分复核、趋势分析等功能。
- **输入/输出**:
    - 输入: 积分请求参数对象 [PointReqDto](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\dto\PointReqDto.java#L11-L46), 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
    - 输出: 包括 [ZjkPointRule](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\ZjkPointRule.java#L18-L65), [ZjkPointReward](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\ZjkPointReward.java#L18-L84), [PointShowVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\PointShowVO.java#L11-L49), [PointTrendVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\PointTrendVO.java#L15-L20) 等多种数据结构
- **处理逻辑**:
```java
// 查询积分规则列表
@GetMapping("/ruleList")
public R<List<ZjkPointRule>> pointRule(PointReqDto dto) {
    QueryWrapper<ZjkPointRule> wq = new QueryWrapper<>();
    wq.lambda().eq(!StringUtils.isEmpty(dto.getStartFlag()), ZjkPointRule::getStatus, dto.getStartFlag())
        .like(!StringUtils.isEmpty(dto.getRuleName()), ZjkPointRule::getRuleName, dto.getRuleName());
    return R.ok(zjkPointRuleService.list(wq));
}

// 新增奖励
@PostMapping("addReward")
public R<Void> addReward(@RequestBody ZjkPointReward bo) {
    boolean save = zjkPointRewardService.save(bo);
    if (save) {
        return R.ok();
    } else {
        return R.fail();
    }
}

// 积分趋势分析
@GetMapping("/pointTrend")
public R<PointTrendVO> pointTrend(String dayKey,String expertId) {
    return zjkPointUserService.getPointTrend(dayKey,expertId);
}
```


- **接口定义**:
    - API签名:
        - `GET /point/ruleList`
        - `POST /point/addReward`
        - `GET /point/pointTrend`
    - 消息格式: JSON
    - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "totalPoints": 850,
    "trendData": [
      {"date": "2024-01", "points": 100},
      {"date": "2024-02", "points": 150}
    ]
  }
}
```


---

#### 模块3：`信用管理`
- **功能描述**: 管理专家的信用记录，包括信用评分、信用等级、奖惩记录等，并提供信用榜单展示和同步功能。
- **输入/输出**:
    - 输入: 信用请求参数对象 [CreditReqDto](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\dto\CreditReqDto.java#L11-L57), 主键ID
    - 输出: 包括 [ZjkCreditVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkCreditVo.java#L22-L85), [ChartBaseCreditVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ChartBaseCreditVO.java#L18-L161), [PointExpertRankVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\PointExpertRankVO.java#L14-L19) 等多种数据结构
- **处理逻辑**:
```java
// 查询信用记录列表
@GetMapping("/list")
public TableDataInfo<ZjkCreditVo> list(ZjkCreditBo bo, PageQuery pageQuery) {
    return zjkCreditService.queryPageList(bo, pageQuery);
}

// 获取专家信用榜基本信息
@GetMapping("/pointBase")
public R<ChartBaseCreditVO> pointBase() {
    return zjkCreditService.getPointBase();
}

// 同步专家信息到信用用户记录表
@GetMapping("/expertPointRank/user")
public R<PointExpertRankVO> expertPointRankUser() {
    return zjkCreditService.expertPointRankUser();
}
```


- **接口定义**:
    - API签名:
        - `GET /credit/list`
        - `GET /credit/pointBase`
        - `GET /credit/expertPointRank/user`
    - 消息格式: JSON
    - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "creditLevel": "A",
    "recentPenalties": 0,
    "totalRewards": 5
  }
}
```


---

#### 模块4：`积分复核与统计`
- **功能描述**: 提供积分复核操作和统计分析功能，包括积分复核列表、复核详情、复核提交等。
- **输入/输出**:
    - 输入: 专家ID, 积分复核对象 [ZjkPointUser](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\ZjkPointUser.java#L14-L76)
    - 输出: 复核结果状态码、积分详情数据
- **处理逻辑**:
```java
// 积分复核列表
@GetMapping("/checkPointList")
public TableDataInfo<PointShowVO> checkPointList(PointReqDto bo, PageQuery pageQuery) {
    return zjkPointUserService.checkPointList(bo, pageQuery);
}

// 积分复核提交
@PostMapping("/pointCheck")
public R<Void> pointCheck(@RequestBody ZjkPointUser dto) {
    return zjkPointUserService.pointCheck(dto);
}

// 积分复核详情
@GetMapping("/pointCheckDetail")
public R<ZjkPointUser> pointCheckDetail(String expertId) {
    QueryWrapper<ZjkPointUser> wq = new QueryWrapper<>();
    wq.lambda().eq(ZjkPointUser::getExpertId,expertId);
    return R.ok(zjkPointUserService.getOne(wq));
}
```


- **接口定义**:
    - API签名:
        - `GET /point/checkPointList`
        - `POST /point/pointCheck`
        - `GET /point/pointCheckDetail`
    - 消息格式: JSON
    - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "expertId": "E1001",
    "totalPoints": 900,
    "status": "已审核"
  }
}
```


---

#### 模块5：`数据导出与文件处理`
- **功能描述**: 提供信用记录的Excel导出功能，支持批量删除和更新操作。
- **输入/输出**:
    - 输入: 导出条件参数对象 [ZjkCreditBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkCreditBo.java#L17-L65)
    - 输出: Excel 文件流
- **处理逻辑**:
```java
// 导出信用记录列表
@PostMapping("/export")
public void export(ZjkCreditBo bo, HttpServletResponse response) {
    List<ZjkCreditVo> list = zjkCreditService.queryList(bo);
    ExcelUtil.exportExcel(list, "信用记录", ZjkCreditVo.class, response);
}

// 删除信用记录
@DeleteMapping("/{IDs}")
public R<Void> remove(@NotEmpty(message = "主键不能为空") @PathVariable Long[] IDs) {
    return toAjax(zjkCreditService.deleteWithValidByIds(List.of(IDs), true));
}
```


- **接口定义**:
    - API签名:
        - `POST /credit/export`
        - `DELETE /credit/{IDs}`
    - 消息格式: 文件流（导出）JSON（删除）
    - 示例响应:
```http
HTTP/1.1 200 OK
Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
Content-Disposition: attachment; filename=credit_records.xlsx
```


