# 专家请假与互评模块详细设计文档

## 模块1：`专家请假管理`

### 功能描述
提供专家的日常请假功能，支持项目评审专家请假、机构管理员审批请假、请假规则配置以及请假统计分析。

### 输入/输出
- **输入**:
    - 请假业务对象 [ZjkLeaveBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveBo.java#L17-L65)
    - 规则配置对象 [ZjkLeaveRuleBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveRuleBo.java#L16-L64)
- **输出**:
    - 请假记录信息 [ZjkLeaveVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkLeaveVo.java#L15-L73)
    - 统计数据封装类 [StsNumVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\StsNumVO.java#L15-L20), [StsLeaveVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\StsLeaveVO.java#L15-L20)

### 处理逻辑
```java
// 查询专家请假列表（专家）
@GetMapping("/list")
public TableDataInfo<ZjkLeaveVo> list(ZjkLeaveBo bo, PageQuery pageQuery) {
    return zjkLeaveService.queryPageList(bo, pageQuery);
}

// 新增请假申请
@PostMapping()
public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkLeaveBo bo) {
    return zjkLeaveService.insertByBo(bo);
}

// 修改请假规则（机构管理员）
@PutMapping("/setRule")
public R<Void> edit(@RequestBody ZjkLeaveRuleBo bo) {
    return toAjax(zjkLeaveRuleService.updateByBo(bo));
}

// 获取请假统计图表
@GetMapping("/stsChart")
public R<StsLeaveVO> stsChart(Integer rangeMonth) {
    return zjkLeaveService.getStsChart(rangeMonth);
}
```


### 接口定义
- API签名:
    - `GET /leave/list`
    - `POST /leave`
    - `PUT /leave/setRule`
    - `GET /leave/stsChart`
- 消息格式: JSON
- 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "totalLeaves": 5,
    "approvedLeaves": 3,
    "pendingLeaves": 2
  }
}
```


---

## 模块2：`专家互评管理`

### 功能描述
支持项目评审结束后对参评专家进行评价打分，包含专家自评、管理员查看、互评统计等功能。

### 输入/输出
- **输入**:
    - 互评业务对象 [ZjkEvaluateVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkEvaluateVO.java#L16-L75)
- **输出**:
    - 互评结果信息 [ZjkEvaluateVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkEvaluateVO.java#L16-L75)
    - 统计数据封装类 [StsEvaluateNumVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\StsEvaluateNumVO.java#L15-L20), [StsEvaluateVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\StsEvaluateVO.java#L15-L20)

### 处理逻辑
```java
// 查询专家评价列表（专家）
@GetMapping("/listToZj")
public TableDataInfo<ZjkEvaluateVO> listToZj(ZjkEvaluateVO bo, PageQuery pageQuery) {
    return zjkEvaluateService.getListToZj(bo, pageQuery);
}

// 新增专家评价
@PostMapping()
public R<Void> addComment(@RequestBody ZjkEvaluateVO bo) {
    return zjkEvaluateService.addComment(bo);
}

// 获取互评统计次数
@GetMapping("/stsNum")
public R<StsEvaluateNumVO> getStsNum() {
    return R.ok(zjkEvaluateService.getStsNum());
}

// 导出互评统计
@PostMapping("/export")
public void export(ZjkEvaluateVO bo, HttpServletResponse response) {
    List<StsListVO> list = zjkEvaluateService.selectStsEvaluateList(bo);
    ExcelUtil.exportExcel(list, "评价统计", StsListVO.class, response);
}
```


### 接口定义
- API签名:
    - `GET /evaluate/listToZj`
    - `POST /evaluate`
    - `GET /evaluate/stsNum`
    - `POST /evaluate/export`
- 消息格式: JSON
- 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "totalEvaluations": 10,
    "averageScore": 4.5
  }
}
```


---

## 模块3：`请假与评审项目的联动管理`

### 功能描述
处理专家请假与其参与评审项目之间的联动关系，包括待接受项目查询、项目请假操作、项目接受确认等。

### 输入/输出
- **输入**:
    - 项目评价对象 [ZjkEvaluateVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkEvaluateVO.java#L16-L75)
- **输出**:
    - 项目信息封装类 [ZjkEvaluateVO](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkEvaluateVO.java#L16-L75)

### 处理逻辑
```java
// 获取待接受项目
@GetMapping("/prosForAccept")
public TableDataInfo<ZjkEvaluateVO> getProsForAccept() {
    return zjkLeaveService.getProsForAccept();
}

// 项目请假
@PostMapping("/leaveForPro")
public R<Void> leaveForPro(@RequestBody ZjkEvaluateVO bo) {
    return zjkLeaveService.leaveForPro(bo);
}

// 项目接受确认
@PostMapping("/setAccept")
public R<Void> setAccept(@RequestBody ZjkEvaluateVO bo) {
    return zjkLeaveService.setAccept(bo);
}
```


### 接口定义
- API签名:
    - `GET /leave/prosForAccept`
    - `POST /leave/leaveForPro`
    - `POST /leave/setAccept`
- 消息格式: JSON
- 示例响应:
```json
{
  "code": 200,
  "msg": "操作成功"
}
```


---

## 模块4：`请假规则与审批流程`

### 功能描述
提供请假规则配置及审批流程管理，供机构管理员设置请假策略并处理请假审批。

### 输入/输出
- **输入**:
    - 请假规则对象 [ZjkLeaveRuleBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkLeaveRuleBo.java#L16-L64)
- **输出**:
    - 规则详情 [ZjkLeaveRuleVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkLeaveRuleVo.java#L15-L74)

### 处理逻辑
```java
// 获取请假规则详情
@GetMapping("/getRule")
public R<ZjkLeaveRuleVo> getLeavelRule() {
    return R.ok(zjkLeaveRuleService.selectRuleByTannet());
}

// 审批请假列表
@GetMapping("/splist")
public TableDataInfo<ZjkLeaveVo> splist(ZjkLeaveBo bo, PageQuery pageQuery) {
    return zjkLeaveService.queryPageSpList(bo, pageQuery);
}

// 修改请假规则
@PutMapping("/setRule")
public R<Void> edit(@RequestBody ZjkLeaveRuleBo bo) {
    return toAjax(zjkLeaveRuleService.updateByBo(bo));
}
```


### 接口定义
- API签名:
    - `GET /leave/getRule`
    - `GET /leave/splist`
    - `PUT /leave/setRule`
- 消息格式: JSON
- 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "maxLeavesPerYear": 5,
    "approvalRequired": true
  }
}
```


