# 专家库系统详细设计文档

## 3. 模块/子系统详细设计

### 3.1 功能模块划分

#### 模块1：`项目管理`
- **功能描述**: 提供项目的增删改查、导出、权限控制等功能，支持不同角色对项目的操作。
- **输入/输出**:
  - 输入: [ZjkProductBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkProductBo.java#L17-L68), 分页查询对象 [PageQuery](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\PageQuery.java#L22-L121)
  - 输出: 包含项目信息的 [ZjkProductVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkProductVo.java#L15-L74) 和分页数据封装类 [TableDataInfo](file://D:\jyh-zjk\ruoyi-common\ruoyi-common-mybatis\src\main\java\org\dromara\common\mybatis\core\page\TableDataInfo.java#L14-L73)
- **处理逻辑**:
```java
// 查询项目管理列表
@GetMapping("/list")
public TableDataInfo<ZjkProductVo> list(ZjkProductBo bo, PageQuery pageQuery) {
    return zjkProductService.queryPageList(bo, pageQuery);
}

// 新增项目管理
@PostMapping()
public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkProductBo bo) {
    return toAjax(zjkProductService.insertByBo(bo));
}

// 修改项目管理
@PostMapping("/update")
public R<Void> edit(@RequestBody ZjkProductBo bo) {
    return toAjax(zjkProductService.updateByBo(bo));
}
```


- **接口定义**:
  - API签名:
    - `GET /product/list`
    - `POST /product`
    - `POST /product/update`
  - 消息格式: JSON
  - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 100,
    "rows": [
      {
        "projectId": 123,
        "projectName": "项目A",
        "status": "进行中"
      }
    ]
  }
}
```


---

#### 模块2：`项目总结评价`
- **功能描述**: 管理项目总结评价，包括评价的增删改查和导出功能。
- **输入/输出**:
  - 输入: 项目总结评价业务对象 [ZjkProjectEvaluationBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkProjectEvaluationBo.java#L17-L66), 主键ID
  - 输出: 包含项目总结评价信息的 [ZjkProjectEvaluationVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkProjectEvaluationVo.java#L15-L74)
- **处理逻辑**:
```java
// 查询项目总结评价列表
@GetMapping("/list")
public TableDataInfo<ZjkProjectEvaluationVo> list(ZjkProjectEvaluationBo bo, PageQuery pageQuery) {
    return zjkProjectEvaluationService.queryPageList(bo, pageQuery);
}

// 新增项目总结评价
@PostMapping("/insert")
public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkProjectEvaluationBo bo) {
    return toAjax(zjkProjectEvaluationService.insertByBo(bo));
}

// 导出项目总结评价列表
@PostMapping("/export")
public void export(ZjkProjectEvaluationBo bo, HttpServletResponse response) {
    List<ZjkProjectEvaluationVo> list = zjkProjectEvaluationService.queryList(bo);
    ExcelUtil.exportExcel(list, "项目总结评价", ZjkProjectEvaluationVo.class, response);
}
```


- **接口定义**:
  - API签名:
    - `GET /projectEvaluation/list`
    - `POST /projectEvaluation/insert`
    - `POST /projectEvaluation/export`
  - 消息格式: JSON
  - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 5,
    "rows": [
      {
        "evaluationId": 123,
        "score": 95
      }
    ]
  }
}
```


---

#### 模块3：`项目阶段文档管理`
- **功能描述**: 管理项目的各个阶段文档，支持文档的增删改查操作。
- **输入/输出**:
  - 输入: 项目阶段文档业务对象 [ZjkProductReviewsnBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkProductReviewsnBo.java#L17-L65)
  - 输出: 包含项目阶段文档信息的 [ZjkProductReviewsnVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkProductReviewsnVo.java#L15-L73)
- **处理逻辑**:
```java
// 查询项目阶段文档管理列表
@GetMapping("/list")
public TableDataInfo<ZjkProductReviewsnVo> list(ZjkProductReviewsnBo bo, PageQuery pageQuery) {
    return zjkProductReviewsnService.queryPageList(bo, pageQuery);
}

// 新增项目阶段文档管理
@PostMapping("/add")
public R<Void> add(@Validated(AddGroup.class) @RequestBody ZjkProductReviewsnBo bo) {
    return toAjax(zjkProductReviewsnService.insertByBo(bo));
}
```


- **接口定义**:
  - API签名:
    - `GET /productReviewsn/list`
    - `POST /productReviewsn/add`
  - 消息格式: JSON
  - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 5,
    "rows": [
      {
        "documentId": 123,
        "documentName": "需求文档"
      }
    ]
  }
}
```


---

#### 模块4：`项目总结与日志`
- **功能描述**: 实现项目的总结撰写、日志记录以及审核功能，包括总结导入导出、审批等操作。
- **输入/输出**:
  - 输入: 项目总结业务对象 [ZjkProductSummarizeBo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\bo\ZjkProductSummarizeBo.java#L17-L68)
  - 输出: 包含项目总结信息的 [ZjkProductSummarizeVo](file://D:\jyh-zjk\ruoyi-modules\zjk-api\src\main\java\org\dromara\zjk\domain\vo\ZjkProductSummarizeVo.java#L15-L73)
- **处理逻辑**:
```java
// 查询项目总结列表
@GetMapping("/list")
public TableDataInfo<ZjkProductSummarizeVo> list(ZjkProductSummarizeBo bo, PageQuery pageQuery) {
    return zjkProductSummarizeService.queryPageList(bo, pageQuery);
}

// 导出项目总结列表
@PostMapping("/export")
public void export(ZjkProductSummarizeBo bo, HttpServletResponse response) {
    List<ZjkProductSummarizeVo> list = zjkProductSummarizeService.queryList(bo);
    List<ZjkProductSummarizeExportVo> zjkProductSummarizeExportVos = BeanUtil.copyToList(list, ZjkProductSummarizeExportVo.class);
    ExcelUtil.exportExcel(zjkProductSummarizeExportVos, "项目总结", ZjkProductSummarizeExportVo.class, response);
}

// 修改项目总结
@PostMapping("/update")
public R<Void> edit(@RequestBody ZjkProductSummarizeBo bo) {
    return toAjax(zjkProductSummarizeService.updateByBo(bo));
}
```


- **接口定义**:
  - API签名:
    - `GET /productSummarize/list`
    - `POST /productSummarize/export`
    - `POST /productSummarize/update`
  - 消息格式: JSON
  - 示例响应:
```json
{
  "code": 200,
  "msg": "success",
  "data": {
    "total": 5,
    "rows": [
      {
        "summaryId": 123,
        "content": "项目按计划完成"
      }
    ]
  }
}
```


