package org.dromara.common.core.constant;

/**
 * 用户常量信息
 *
 * @author ruoyi
 */
public interface UserConstants {

    /**
     * 平台内系统用户的唯一标志
     */
    String SYS_USER = "SYS_USER";

    /**
     * 正常状态
     */
    String NORMAL = "0";

    /**
     * 异常状态
     */
    String EXCEPTION = "1";

    /**
     * 用户正常状态
     */
    String USER_NORMAL = "0";

    /**
     * 用户封禁状态
     */
    String USER_DISABLE = "1";

    /**
     * 角色正常状态
     */
    String ROLE_NORMAL = "0";

    /**
     * 角色封禁状态
     */
    String ROLE_DISABLE = "1";

    /**
     * 部门正常状态
     */
    String DEPT_NORMAL = "0";

    /**
     * 部门停用状态
     */
    String DEPT_DISABLE = "1";

    /**
     * 岗位正常状态
     */
    String POST_NORMAL = "0";

    /**
     * 岗位停用状态
     */
    String POST_DISABLE = "1";

    /**
     * 字典正常状态
     */
    String DICT_NORMAL = "0";

    /**
     * 通用存在标志
     */
    String DEL_FLAG_NORMAL = "0";

    /**
     * 通用删除标志
     */
    String DEL_FLAG_REMOVED  = "2";

    /**
     * 是否为系统默认（是）
     */
    String YES = "Y";

    /**
     * 是否菜单外链（是）
     */
    String YES_FRAME = "0";

    /**
     * 是否菜单外链（否）
     */
    String NO_FRAME = "1";

    /**
     * 菜单正常状态
     */
    String MENU_NORMAL = "0";

    /**
     * 菜单停用状态
     */
    String MENU_DISABLE = "1";

    /**
     * 菜单类型（目录）
     */
    String TYPE_DIR = "M";

    /**
     * 菜单类型（菜单）
     */
    String TYPE_MENU = "C";

    /**
     * 菜单类型（按钮）
     */
    String TYPE_BUTTON = "F";

    /**
     * Layout组件标识
     */
    String LAYOUT = "Layout";

    /**
     * ParentView组件标识
     */
    String PARENT_VIEW = "ParentView";

    /**
     * InnerLink组件标识
     */
    String INNER_LINK = "InnerLink";

    /**
     * 用户名长度限制
     */
    int USERNAME_MIN_LENGTH = 2;
    int USERNAME_MAX_LENGTH = 20;

    /**
     * 密码长度限制
     */
    int PASSWORD_MIN_LENGTH = 5;
    int PASSWORD_MAX_LENGTH = 20;

    /**
     * 超级管理员ID
     */
    Long SUPER_ADMIN_ID = 1L;
    /**
     * 委办局字典key
     */
    String WBJ_DIC_TYPE ="department_login";
    /**
     * 请假类型
     */
    String LEAVE_TYPE = "qjlx";
    String APPROVAL_STATUS = "approval_status";
    String ITEM_STAGE = "item_stage";

    String ROLE_NAME_CN = "专家";
    /**
     * 专家
     */
    String ROLE_NAME_ZJ_KEY = "expert";
    /**
     * 机构管理员
     */
    String ROLE_NAME_ZJ_JG = "jg";

    Long LEAVE_DAY = 30L;

    String LEAVE_BEFORE_PRO = "2";
    String LEAVE_BEFORE_DAY = "1";
    String APPROVAL_STATUS_AGREE = "1";
    String APPROVAL_STATUS_NOT_AGREE = "0";
    String APPROVAL_STATUS_TURN_DOWN= "2";

    /**
     * 项目请假
     */
    String LEAVE_TYPE_PRO = "2";
    String POINT_EVALUATE_KEY = "EVALUATE_KEY";
    /**
     * 审核状态;1：冻结；2：复核通过;3：待复核；;0初始默认状态
     */
    Integer CHECK_STATUS_WAIT = 3;
    //信用规则
    Integer CREDIT_REVIEW_KEY = 1;
    Integer CREDIT_LEAVE_KEY =2;
    Integer CREDIT_ABSENCE_KEY = 3;
    /**
     * 短信成功
     */
    Integer SMS_SEND_SUCESS = 1;
    /**
     * 短信失败
     */
    Integer SMS_SEND_FAIL = 0;
}
