package org.dromara.common.sms.client;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SOAPMessageUtil {

	public static String getString(SOAPMessage message){
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		try {
			message.writeTo(out);
			return out.toString();
		} catch (SOAPException | IOException e) {
			e.printStackTrace();
		}
		return "";
	}

	public static byte[] getBytes(SOAPMessage message){
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		try {
			message.writeTo(out);
			return out.toByteArray();
		} catch (SOAPException | IOException e) {
			e.printStackTrace();
		}
		return new byte[0];
	}

}
