package org.dromara.system;

import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

/**
 * 系统模块
 *
 * @author ruoyi
 */
@EnableAspectJAutoProxy(proxyTargetClass = true)
@EnableDubbo
@SpringBootApplication(scanBasePackages = {
    "org.dromara.system",
    "org.dromara.common"
})
public class RuoYiSystemApplication {
    public static void main(String[] args) {
        SpringApplication application = new SpringApplication(RuoYiSystemApplication.class);
        application.setApplicationStartup(new BufferingApplicationStartup(2048));
        application.run(args);
        System.out.println("(♥◠‿◠)ﾉﾞ  系统模块启动成功   ლ(´ڡ`ლ)ﾞ  ");
    }
}
