package org.dromara.system.controller.system;

import org.dromara.common.core.domain.R;
import org.dromara.system.domain.SysAreas;
import org.dromara.system.domain.SysCities;
import org.dromara.system.domain.SysProvinces;
import org.dromara.system.domain.vo.SysProvinceCAVo;
import org.dromara.system.service.SysProvincesService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author : yanguohua
 * @version : 1.0
 * @date : 2024/11/4 16:21
 */
@RestController
@RequestMapping("/area")
public class SysAreaController {
    @Resource
    private SysProvincesService sysProvincesService;

    @GetMapping("/provinces")
    public R<List<SysProvinces>> getProvinces() {
        return R.ok(sysProvincesService.list());
    }

    @GetMapping("/cities/{provinceId}")
    public R<List<SysCities>> getCities(@PathVariable Long provinceId) {
        return sysProvincesService.getCitiesByProvince(provinceId);
    }

    @GetMapping("/areas/{cityId}")
    public  R<List<SysAreas>> getAreas(@PathVariable Long cityId) {
        return sysProvincesService.getAreasByCity(cityId);
    }


    @GetMapping("/getProvince")
    public R<List<SysProvinceCAVo>> getProvince() {
        return R.ok(sysProvincesService.getProvince());
    }

    /**
     * 获取省市区名称
     * @param provinceId 省级代码
     * @param cityId 市级代码
     * @param areaId 区级代码
     * @return 返回省、市、区对应的名称
     */
    @GetMapping("/getRegionNames")
    public R<Map<String, String>> getRegionNames(@RequestParam("provinceId") Long provinceId,
                                                              @RequestParam("cityId") Long cityId,
                                                              @RequestParam("areaId") Long areaId) {
        // 调用 Service 查询省市区名称
        Map<String, String> regionNames = sysProvincesService.getRegionNames(provinceId, cityId, areaId);
        return R.ok(regionNames);
    }

}
